/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.scanner;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.neo4j.ogm.metadata.ClassFileProcessor;
import org.neo4j.ogm.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathScanner {
    private List<String> classPaths;
    private ClassFileProcessor processor;
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassPathScanner.class);

    private void scanFile(File file, String relativePath) throws IOException {
        if (relativePath.endsWith(".class")) {
            try (FileInputStream inputStream = new FileInputStream(file);){
                this.processor.process(inputStream);
            }
        }
    }

    private void scanFolder(File folder, int prefixSize) throws IOException {
        String absolutePath = folder.getPath();
        String relativePath = prefixSize > absolutePath.length() ? "" : absolutePath.substring(prefixSize);
        File[] subFiles = folder.listFiles();
        if (subFiles != null) {
            for (File subFile : subFiles) {
                if (subFile.isDirectory()) {
                    this.scanFolder(subFile, prefixSize);
                    continue;
                }
                if (!subFile.isFile()) continue;
                String leafSuffix = "/" + subFile.getName();
                this.scanFile(subFile, relativePath + leafSuffix);
            }
        }
    }

    private void scanZipFile(ZipFile zipFile) throws IOException {
        LOGGER.debug("Scanning zipFile {}", (Object)zipFile.getName());
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            InputStream inputStream = zipFile.getInputStream(entry);
            Throwable throwable = null;
            try {
                if (entry.getName().endsWith(".class")) {
                    this.scanClassFileEntry(inputStream, entry);
                    continue;
                }
                if (!this.isArchive(entry.getName())) continue;
                this.scanZippedEntry(inputStream, entry);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
    }

    private void scanClassFileEntry(InputStream inputStream, ZipEntry entry) throws IOException {
        String name = entry.getName();
        LOGGER.trace("Scanning class entry: {}", (Object)name);
        for (String pathToScan : this.classPaths) {
            if (!name.contains(pathToScan)) continue;
            LOGGER.debug("{} found in {}", (Object)pathToScan, (Object)name);
            this.processor.process(inputStream);
            break;
        }
    }

    private void scanZippedEntry(InputStream inputStream, ZipEntry entry) throws IOException {
        String name = entry.getName();
        LOGGER.debug("Scanning zipped entry: {}", (Object)name);
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            if (!zipEntry.isDirectory()) {
                if (zipEntry.getName().endsWith(".class")) {
                    this.scanClassFileEntry(zipInputStream, zipEntry);
                } else if (this.isArchive(zipEntry.getName())) {
                    this.scanZippedEntry(zipInputStream, zipEntry);
                }
            }
            zipEntry = zipInputStream.getNextEntry();
        }
    }

    public void scan(List<String> classPaths, ClassFileProcessor processor) {
        this.classPaths = classPaths;
        this.processor = processor;
        Set<File> classPathElements = this.getUniqueClasspathElements(classPaths);
        LOGGER.debug("Classpath elements:");
        for (File classPathElement : classPathElements) {
            LOGGER.debug(classPathElement.getPath());
        }
        try {
            for (File classPathElement : classPathElements) {
                String path = classPathElement.getPath();
                if (classPathElement.isDirectory()) {
                    this.scanFolder(classPathElement, path.length() + 1);
                    continue;
                }
                if (!classPathElement.isFile()) continue;
                if (this.isArchive(path)) {
                    this.scanZipFile(new ZipFile(classPathElement));
                    continue;
                }
                this.scanFile(classPathElement, classPathElement.getName());
            }
            processor.finish();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Set<File> getUniqueClasspathElements(List<String> classPaths) {
        return ClassUtils.getUniqueClasspathElements(classPaths);
    }

    private boolean isArchive(String s) {
        return (s = s.toLowerCase()).endsWith(".jar") || s.endsWith(".zip") || s.endsWith(".war");
    }
}

