/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.ogm.MetaData;
import org.neo4j.ogm.autoindex.AutoIndexManager;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.service.Components;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.event.EventListener;

public class SessionFactory {
    private final MetaData metaData;
    private final AutoIndexManager autoIndexManager;
    private final List<EventListener> eventListeners;

    private SessionFactory(Configuration configuration, MetaData metaData) {
        if (configuration != null) {
            Components.configure((Configuration)configuration);
        }
        this.metaData = metaData;
        this.autoIndexManager = new AutoIndexManager(this.metaData, Components.driver());
        this.autoIndexManager.build();
        this.eventListeners = new CopyOnWriteArrayList<EventListener>();
    }

    public SessionFactory(String ... packages) {
        this(null, new MetaData(packages));
    }

    public SessionFactory(Class ... classes) {
        this(null, new MetaData(classes));
    }

    public SessionFactory(Configuration configuration, String ... packages) {
        this(configuration, new MetaData(packages));
    }

    public SessionFactory(Configuration configuration, Class ... classes) {
        this(configuration, new MetaData(classes));
    }

    public MetaData metaData() {
        return this.metaData;
    }

    public Session openSession() {
        return new Neo4jSession(this.metaData, Components.driver(), this.eventListeners);
    }

    public void register(EventListener eventListener) {
        this.eventListeners.add(eventListener);
    }

    public void deregister(EventListener eventListener) {
        this.eventListeners.remove(eventListener);
    }

    public void close() {
    }
}

