/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.neo4j.ogm.compiler.CompileContext;
import org.neo4j.ogm.context.EntityGraphMapper;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.session.Capability;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.event.SaveEventDelegate;
import org.neo4j.ogm.session.request.RequestExecutor;

public class SaveDelegate
implements Capability.Save {
    private final Neo4jSession session;
    private final RequestExecutor requestExecutor;

    public SaveDelegate(Neo4jSession neo4jSession) {
        this.session = neo4jSession;
        this.requestExecutor = new RequestExecutor(neo4jSession);
    }

    @Override
    public <T> void save(T object) {
        this.save(object, -1);
    }

    @Override
    public <T> void save(T object, int depth) {
        SaveEventDelegate eventsDelegate = new SaveEventDelegate(this.session);
        if (object.getClass().isArray() || Iterable.class.isAssignableFrom(object.getClass())) {
            ArrayList<Object> objects;
            if (object.getClass().isArray()) {
                int length = Array.getLength(object);
                objects = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    Object object2 = Array.get(object, i);
                    objects.add(object2);
                }
            } else {
                objects = (ArrayList<Object>)object;
            }
            ArrayList<CompileContext> contexts = new ArrayList<CompileContext>();
            for (Object e : objects) {
                if (this.session.eventsEnabled()) {
                    eventsDelegate.preSave(object);
                }
                contexts.add(new EntityGraphMapper(this.session.metaData(), this.session.context()).map(e, depth));
            }
            this.requestExecutor.executeSave(contexts);
            if (this.session.eventsEnabled()) {
                eventsDelegate.postSave();
            }
        } else {
            ClassInfo classInfo = this.session.metaData().classInfo(object);
            if (classInfo != null) {
                if (this.session.eventsEnabled()) {
                    eventsDelegate.preSave(object);
                }
                CompileContext context = new EntityGraphMapper(this.session.metaData(), this.session.context()).map(object, depth);
                this.requestExecutor.executeSave(context);
                if (this.session.eventsEnabled()) {
                    eventsDelegate.postSave();
                }
            } else {
                this.session.warn(object.getClass().getName() + " is not an instance of a persistable class");
            }
        }
    }
}

