/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import org.neo4j.ogm.session.Capability;
import org.neo4j.ogm.session.GraphCallback;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.transaction.Transaction;

public class TransactionsDelegate
implements Capability.Transactions {
    private final Neo4jSession session;

    public TransactionsDelegate(Neo4jSession neo4jSession) {
        this.session = neo4jSession;
    }

    @Override
    public Transaction beginTransaction() {
        this.session.debug("beginTransaction()");
        this.session.debug("Neo4jSession identity: " + this);
        Transaction tx = this.session.transactionManager().openTransaction();
        this.session.debug("Transaction, tx id: " + tx);
        return tx;
    }

    @Override
    public Transaction beginTransaction(Transaction.Type type) {
        this.session.debug("beginTransaction()");
        this.session.debug("Neo4jSession identity: " + this);
        Transaction tx = this.session.transactionManager().openTransaction(type);
        this.session.debug("Transaction, tx id: " + tx);
        return tx;
    }

    @Override
    @Deprecated
    public <T> T doInTransaction(GraphCallback<T> graphCallback) {
        return graphCallback.apply(this.session.requestHandler(), this.getTransaction(), this.session.metaData());
    }

    @Override
    public Transaction getTransaction() {
        return this.session.transactionManager().getCurrentTransaction();
    }
}

