/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.lang.reflect.Array;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class NumberArrayStringConverter
implements AttributeConverter<Number[], String[]> {
    private final Class<? extends Number> numberClass;

    public NumberArrayStringConverter(Class<? extends Number> numberClass) {
        this.numberClass = numberClass;
    }

    public String[] toGraphProperty(Number[] value) {
        if (value == null) {
            return null;
        }
        String[] values = new String[value.length];
        int i = 0;
        for (Number num : value) {
            values[i++] = num.toString();
        }
        return values;
    }

    public Number[] toEntityAttribute(String[] stringValues) {
        if (stringValues == null) {
            return null;
        }
        Number[] values = (Number[])Array.newInstance(this.numberClass, stringValues.length);
        int i = 0;
        try {
            for (String num : stringValues) {
                values[i++] = this.numberClass.getDeclaredConstructor(String.class).newInstance(num);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return values;
    }
}

