/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.neo4j.ogm.metadata.MethodInfo;

public class MethodsInfo {
    private final Set<MethodInfo> methods;

    MethodsInfo() {
        this.methods = new HashSet<MethodInfo>();
    }

    public MethodsInfo(Class<?> cls) {
        this.methods = new HashSet<MethodInfo>();
        Class<?> currentClass = cls;
        do {
            Set methodInfoOfCurrentClass = Arrays.stream(currentClass.getDeclaredMethods()).filter(MethodsInfo::includeMethod).map(MethodInfo::of).collect(Collectors.toSet());
            this.methods.addAll(methodInfoOfCurrentClass);
        } while ((currentClass = currentClass.getSuperclass()) != null);
    }

    @Deprecated
    public MethodsInfo(Map<String, MethodInfo> methods) {
        this.methods = new HashSet<MethodInfo>(methods.values());
    }

    @Deprecated
    public Collection<MethodInfo> methods() {
        return Collections.unmodifiableCollection(this.methods);
    }

    Collection<MethodInfo> findMethodInfoBy(Predicate<MethodInfo> predicate) {
        return this.methods.stream().filter(predicate).collect(Collectors.toList());
    }

    public void append(MethodsInfo methodsInfo) {
        this.methods.addAll(methodsInfo.methods);
    }

    private static boolean includeMethod(Method method) {
        int modifiers = method.getModifiers();
        return !Modifier.isTransient(modifiers) && !Modifier.isStatic(modifiers);
    }
}

