/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.udc.impl;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.neo4j.ext.udc.UdcSettings;
import org.neo4j.ext.udc.impl.DefaultUdcInformationCollector;
import org.neo4j.ext.udc.impl.UdcTimerTask;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.KernelExtension;
import org.neo4j.kernel.configuration.Config;

public class UdcExtensionImpl
extends KernelExtension<UdcTimerTask> {
    static final String KEY = "kernel udc";
    private Timer timer;

    public UdcExtensionImpl() {
        super(KEY);
    }

    public Class getSettingsClass() {
        return GraphDatabaseSettings.class;
    }

    protected UdcTimerTask load(KernelData kernel) {
        Config config;
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (!((Boolean)(config = this.loadConfig(kernel)).get(UdcSettings.udc_enabled)).booleanValue()) {
            return null;
        }
        int firstDelay = (Integer)config.get(UdcSettings.first_delay);
        int interval = (Integer)config.get(UdcSettings.interval);
        String hostAddress = (String)config.get(UdcSettings.udc_host);
        DefaultUdcInformationCollector collector = new DefaultUdcInformationCollector(config, kernel);
        UdcTimerTask task = new UdcTimerTask(hostAddress, collector);
        this.timer = new Timer("Neo4j UDC Timer", true);
        this.timer.scheduleAtFixedRate((TimerTask)task, firstDelay, (long)interval);
        return task;
    }

    private Config loadConfig(KernelData kernel) {
        Properties udcProps = this.loadUdcProperties();
        HashMap<String, String> config = new HashMap<String, String>(kernel.getConfig().getParams());
        for (Map.Entry<Object, Object> entry : udcProps.entrySet()) {
            config.put((String)entry.getKey(), (String)entry.getValue());
        }
        return new Config(config);
    }

    protected void unload(UdcTimerTask task) {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private Properties loadUdcProperties() {
        Properties sysProps = new Properties();
        try {
            InputStream resource = ((Object)((Object)this)).getClass().getResourceAsStream("/org/neo4j/ext/udc/udc.properties");
            if (resource != null) {
                sysProps.load(resource);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sysProps;
    }
}

