/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.io.EOFException;
import java.io.IOException;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;

public final class ErrorMessageResponse
implements Response {
    private boolean terminating;
    private String message;

    public void process(LoggedDataInputStream loggedDataInputStream, ResponseServices responseServices) throws ResponseException {
        try {
            String string = loggedDataInputStream.readLine();
            this.terminating |= string.endsWith(" [server aborted]: received termination signal");
            this.terminating |= string.endsWith(" [server aborted]: received broken pipe signal");
            this.terminating |= string.endsWith(" [checkout aborted]: end of file from server (consult above messages if any)");
            this.terminating &= loggedDataInputStream.available() == 0;
            this.message = string;
            MessageEvent messageEvent = new MessageEvent(this, string, true);
            responseServices.getEventManager().fireCVSEvent(messageEvent);
        }
        catch (EOFException eOFException) {
            throw new ResponseException(eOFException, ResponseException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (IOException iOException) {
            throw new ResponseException(iOException);
        }
    }

    public boolean isTerminalResponse() {
        return this.terminating;
    }

    public String getMessage() {
        return this.message;
    }
}

