/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.util.BitSet;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.netpreserve.jwarc.MessageParser;

public class MediaType
extends MessageParser {
    private static BitSet tokenChars = new BitSet();
    private static final byte[] _media_type_actions;
    private static final short[] _media_type_key_offsets;
    private static final char[] _media_type_trans_keys;
    private static final byte[] _media_type_single_lengths;
    private static final byte[] _media_type_range_lengths;
    private static final byte[] _media_type_index_offsets;
    private static final byte[] _media_type_indicies;
    private static final byte[] _media_type_trans_targs;
    private static final byte[] _media_type_trans_actions;
    private static final byte[] _media_type_eof_actions;
    static final int media_type_start = 1;
    public static final MediaType JSON;
    public static MediaType HTML;
    public static MediaType HTML_UTF8;
    public static MediaType HTTP;
    public static MediaType HTTP_REQUEST;
    public static MediaType HTTP_RESPONSE;
    public static MediaType OCTET_STREAM;
    public static MediaType WARC_FIELDS;
    public static final MediaType WWW_FORM_URLENCODED;
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;
    private int hashCode;

    private static byte[] init__media_type_actions_0() {
        return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 2, 4, 3};
    }

    private static short[] init__media_type_key_offsets_0() {
        return new short[]{0, 0, 15, 29, 44, 47, 64, 80, 95, 102, 109, 114, 132, 150};
    }

    private static char[] init__media_type_trans_keys_0() {
        return new char[]{'!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '!', '/', '|', '~', '#', '\'', '*', '+', '-', '9', 'A', 'Z', '^', 'z', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', ' ', ';', '\t', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '!', '=', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\"', '|', '~', '!', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\"', '\\', '\u007f', '\u0000', '\b', '\n', '\u001f', '\"', '\\', '\u007f', '\u0000', '\b', '\n', '\u001f', '\u007f', '\u0000', '\b', '\n', '\u001f', '\t', ' ', '!', ';', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', ' ', '!', ';', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', ' ', ';', '\u0000'};
    }

    private static byte[] init__media_type_single_lengths_0() {
        return new byte[]{0, 3, 4, 3, 3, 5, 4, 3, 3, 3, 1, 6, 6, 3};
    }

    private static byte[] init__media_type_range_lengths_0() {
        return new byte[]{0, 6, 5, 6, 0, 6, 6, 6, 2, 2, 2, 6, 6, 0};
    }

    private static byte[] init__media_type_index_offsets_0() {
        return new byte[]{0, 0, 10, 20, 30, 34, 46, 57, 67, 73, 79, 83, 96, 109};
    }

    private static byte[] init__media_type_indicies_0() {
        return new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 2, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 4, 4, 5, 0, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 7, 8, 7, 7, 7, 7, 7, 7, 7, 7, 0, 10, 9, 9, 9, 9, 9, 9, 9, 9, 0, 12, 13, 0, 0, 0, 11, 15, 16, 0, 0, 0, 14, 0, 0, 0, 17, 18, 18, 3, 19, 3, 3, 3, 3, 3, 3, 3, 3, 0, 20, 20, 21, 22, 21, 21, 21, 21, 21, 21, 21, 21, 0, 23, 23, 24, 0, 0};
    }

    private static byte[] init__media_type_trans_targs_0() {
        return new byte[]{0, 2, 3, 11, 4, 5, 6, 6, 7, 12, 8, 9, 13, 10, 9, 13, 10, 8, 4, 5, 4, 12, 5, 4, 5};
    }

    private static byte[] init__media_type_trans_actions_0() {
        return new byte[]{5, 0, 21, 0, 0, 0, 15, 0, 17, 19, 13, 7, 0, 0, 25, 9, 9, 11, 23, 23, 1, 0, 1, 3, 3};
    }

    private static byte[] init__media_type_eof_actions_0() {
        return new byte[]{0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 23, 1, 3};
    }

    /*
     * Unable to fully structure code
     */
    public static MediaType parse(String string) {
        map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        p = 0;
        eof = pe = string.length();
        typeEnd = 0;
        subtypeEnd = 0;
        nameStart = 0;
        nameEnd = 0;
        valueStart = 0;
        buf = new StringBuilder();
        cs = 1;
        _trans = 0;
        _goto_targ = 0;
        block26: while (true) {
            switch (_goto_targ) {
                case 0: {
                    if (p == pe) {
                        _goto_targ = 4;
                        continue block26;
                    }
                    if (cs == 0) {
                        _goto_targ = 5;
                        continue block26;
                    }
                }
                case 1: {
                    _keys = MediaType._media_type_key_offsets[cs];
                    _trans = MediaType._media_type_index_offsets[cs];
                    _klen = MediaType._media_type_single_lengths[cs];
                    if (_klen <= 0) ** GOTO lbl41
                    _lower = _keys;
                    _upper = _keys + _klen - 1;
                    while (_upper >= _lower) {
                        _mid = _lower + (_upper - _lower >> 1);
                        if (string.charAt(p) < MediaType._media_type_trans_keys[_mid]) {
                            _upper = _mid - 1;
                            continue;
                        }
                        if (string.charAt(p) > MediaType._media_type_trans_keys[_mid]) {
                            _lower = _mid + 1;
                            continue;
                        }
                        _trans += _mid - _keys;
                        ** GOTO lbl55
                    }
                    _keys += _klen;
                    _trans += _klen;
lbl41:
                    // 2 sources

                    if ((_klen = MediaType._media_type_range_lengths[cs]) > 0) {
                        _lower = _keys;
                        _upper = _keys + (_klen << 1) - 2;
                        while (_upper >= _lower) {
                            _mid = _lower + (_upper - _lower >> 1 & -2);
                            if (string.charAt(p) < MediaType._media_type_trans_keys[_mid]) {
                                _upper = _mid - 2;
                                continue;
                            }
                            if (string.charAt(p) > MediaType._media_type_trans_keys[_mid + 1]) {
                                _lower = _mid + 2;
                                continue;
                            }
                            _trans += _mid - _keys >> 1;
                            ** GOTO lbl55
                        }
                        _trans += _klen;
                    }
lbl55:
                    // 5 sources

                    _trans = MediaType._media_type_indicies[_trans];
                    cs = MediaType._media_type_trans_targs[_trans];
                    if (MediaType._media_type_trans_actions[_trans] != 0) {
                        _acts = MediaType._media_type_trans_actions[_trans];
                        _nacts = MediaType._media_type_actions[_acts++];
                        while (_nacts-- > 0) {
                            switch (MediaType._media_type_actions[_acts++]) {
                                case 0: {
                                    name = string.substring(nameStart, nameEnd);
                                    value = string.substring(valueStart, p);
                                    map.putIfAbsent(name, value);
                                    break;
                                }
                                case 1: {
                                    name = string.substring(nameStart, nameEnd);
                                    value = buf.toString();
                                    map.putIfAbsent(name, value);
                                    break;
                                }
                                case 2: {
                                    if (p < 0) break;
                                    throw new IllegalArgumentException("parse error at position " + p + ": " + MediaType.getErrorContext(string, p, 40));
                                }
                                case 3: {
                                    valueStart = p;
                                    break;
                                }
                                case 4: {
                                    buf.append(string, valueStart, p);
                                    break;
                                }
                                case 5: {
                                    buf.append(string.charAt(p));
                                    break;
                                }
                                case 6: {
                                    buf.setLength(0);
                                    break;
                                }
                                case 7: {
                                    nameStart = p;
                                    break;
                                }
                                case 8: {
                                    nameEnd = p;
                                    break;
                                }
                                case 9: {
                                    valueStart = p;
                                    break;
                                }
                                case 10: {
                                    typeEnd = p;
                                    break;
                                }
                                case 11: {
                                    subtypeEnd = p;
                                }
                            }
                        }
                    }
                }
                case 2: {
                    if (cs == 0) {
                        _goto_targ = 5;
                        continue block26;
                    }
                    if (++p != pe) {
                        _goto_targ = 1;
                        continue block26;
                    }
                }
                case 4: {
                    if (p != eof) break block26;
                    __acts = MediaType._media_type_eof_actions[cs];
                    __nacts = MediaType._media_type_actions[__acts++];
                    while (__nacts-- > 0) {
                        switch (MediaType._media_type_actions[__acts++]) {
                            case 0: {
                                name = string.substring(nameStart, nameEnd);
                                value = string.substring(valueStart, p);
                                map.putIfAbsent(name, value);
                                break;
                            }
                            case 1: {
                                name = string.substring(nameStart, nameEnd);
                                value = buf.toString();
                                map.putIfAbsent(name, value);
                                break;
                            }
                            case 2: {
                                if (p < 0) break;
                                throw new IllegalArgumentException("parse error at position " + p + ": " + MediaType.getErrorContext(string, p, 40));
                            }
                            case 11: {
                                subtypeEnd = p;
                            }
                        }
                    }
                    break block26;
                }
            }
            break;
        }
        type = string.substring(0, typeEnd);
        subtype = string.substring(typeEnd + 1, subtypeEnd);
        parameters = Collections.unmodifiableMap(map);
        return new MediaType(type, subtype, parameters);
    }

    private MediaType(String type, String subtype, Map<String, String> parameters) {
        this.type = type;
        this.subtype = subtype;
        this.parameters = parameters;
    }

    public String type() {
        return this.type;
    }

    public String subtype() {
        return this.subtype;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaType that = (MediaType)o;
        if (this.hashCode != 0 && this.hashCode != that.hashCode && that.hashCode != 0) {
            return false;
        }
        return this.subtype.equalsIgnoreCase(that.subtype) && this.type.equalsIgnoreCase(that.type) && this.parameters.equals(that.parameters);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.type.toLowerCase(Locale.ROOT).hashCode();
            result = 31 * result + this.subtype.toLowerCase(Locale.ROOT).hashCode();
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                result = 31 * result + entry.getKey().toLowerCase(Locale.ROOT).hashCode();
                result = 31 * result + entry.getValue().hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type).append('/').append(this.subtype);
        for (Map.Entry<String, String> parameter : this.parameters.entrySet()) {
            sb.append(';');
            sb.append(parameter.getKey());
            sb.append('=');
            String value = parameter.getValue();
            if (!MediaType.validToken(value)) {
                sb.append('\"');
                sb.append(value.replace("\\", "\\\\").replace("\"", "\\\""));
                sb.append('\"');
                continue;
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public MediaType base() {
        return new MediaType(this.type, this.subtype, Collections.emptyMap());
    }

    private static boolean validToken(String s) {
        return s.chars().allMatch(tokenChars::get);
    }

    static {
        "!#$%&'*+-.^_`|~ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890".chars().forEach(tokenChars::set);
        _media_type_actions = MediaType.init__media_type_actions_0();
        _media_type_key_offsets = MediaType.init__media_type_key_offsets_0();
        _media_type_trans_keys = MediaType.init__media_type_trans_keys_0();
        _media_type_single_lengths = MediaType.init__media_type_single_lengths_0();
        _media_type_range_lengths = MediaType.init__media_type_range_lengths_0();
        _media_type_index_offsets = MediaType.init__media_type_index_offsets_0();
        _media_type_indicies = MediaType.init__media_type_indicies_0();
        _media_type_trans_targs = MediaType.init__media_type_trans_targs_0();
        _media_type_trans_actions = MediaType.init__media_type_trans_actions_0();
        _media_type_eof_actions = MediaType.init__media_type_eof_actions_0();
        JSON = MediaType.parse("application/json");
        HTML = MediaType.parse("text/html");
        HTML_UTF8 = MediaType.parse("text/html;charset=utf-8s");
        HTTP = MediaType.parse("application/http");
        HTTP_REQUEST = MediaType.parse("application/http;msgtype=request");
        HTTP_RESPONSE = MediaType.parse("application/http;msgtype=response");
        OCTET_STREAM = MediaType.parse("application/octet-stream");
        WARC_FIELDS = MediaType.parse("application/warc-fields");
        WWW_FORM_URLENCODED = MediaType.parse("application/x-www-form-urlencoded");
    }
}

