/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.h2.hpack;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.smartboot.http.common.codec.h2.hpack.BinaryRepresentationWriter;
import org.smartboot.http.common.codec.h2.hpack.BulkSizeUpdateWriter;
import org.smartboot.http.common.codec.h2.hpack.HeaderTable;
import org.smartboot.http.common.codec.h2.hpack.IndexedWriter;
import org.smartboot.http.common.codec.h2.hpack.LiteralNeverIndexedWriter;
import org.smartboot.http.common.codec.h2.hpack.LiteralWithIndexingWriter;
import org.smartboot.http.common.codec.h2.hpack.LiteralWriter;
import org.smartboot.http.common.codec.h2.hpack.QuickHuffman;
import org.smartboot.http.common.codec.h2.hpack.SizeUpdateWriter;

public class Encoder {
    private static final AtomicLong ENCODERS_IDS = new AtomicLong();
    private final QuickHuffman.Writer huffmanWriter = new QuickHuffman.Writer();
    private final long id;
    private final IndexedWriter indexedWriter = new IndexedWriter();
    private final LiteralWriter literalWriter = new LiteralWriter();
    private final LiteralNeverIndexedWriter literalNeverIndexedWriter = new LiteralNeverIndexedWriter();
    private final LiteralWithIndexingWriter literalWithIndexingWriter = new LiteralWithIndexingWriter();
    private final SizeUpdateWriter sizeUpdateWriter = new SizeUpdateWriter();
    private final BulkSizeUpdateWriter bulkSizeUpdateWriter = new BulkSizeUpdateWriter();
    private BinaryRepresentationWriter writer;
    private final HeaderTable headerTable;
    private boolean encoding;
    private int maxCapacity;
    private int currCapacity;
    private int lastCapacity;
    private long minCapacity;
    private boolean capacityUpdate;
    private boolean configuredCapacityUpdate;

    public Encoder(int maxCapacity) {
        this.id = ENCODERS_IDS.incrementAndGet();
        if (maxCapacity < 0) {
            throw new IllegalArgumentException("maxCapacity >= 0: " + maxCapacity);
        }
        this.minCapacity = Long.MAX_VALUE;
        this.currCapacity = -1;
        this.setMaxCapacity0(maxCapacity);
        this.headerTable = new HeaderTable(this.lastCapacity);
    }

    public void header(CharSequence name, CharSequence value) throws IllegalStateException {
        this.header(name, value, false);
    }

    public void header(CharSequence name, CharSequence value, boolean sensitive) throws IllegalStateException {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        HeaderTable t = this.getHeaderTable();
        int index = t.indexOf(name, value);
        if (index > 0) {
            this.indexed(index);
        } else {
            boolean huffmanValue = this.isHuffmanBetterFor(value);
            if (index < 0) {
                if (sensitive) {
                    this.literalNeverIndexed(-index, value, huffmanValue);
                } else {
                    this.literal(-index, value, huffmanValue);
                }
            } else {
                boolean huffmanName = this.isHuffmanBetterFor(name);
                if (sensitive) {
                    this.literalNeverIndexed(name, huffmanName, value, huffmanValue);
                } else {
                    this.literal(name, huffmanName, value, huffmanValue);
                }
            }
        }
    }

    private boolean isHuffmanBetterFor(CharSequence value) {
        return this.huffmanWriter.lengthOf(value) < value.length();
    }

    public void setMaxCapacity(int capacity) {
        this.setMaxCapacity0(capacity);
    }

    private void setMaxCapacity0(int capacity) {
        this.checkEncoding();
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity >= 0: " + capacity);
        }
        int calculated = this.calculateCapacity(capacity);
        if (calculated < 0 || calculated > capacity) {
            throw new IllegalArgumentException(String.format("0 <= calculated <= capacity: calculated=%s, capacity=%s", calculated, capacity));
        }
        this.capacityUpdate = true;
        this.maxCapacity = capacity;
        this.lastCapacity = calculated;
        this.minCapacity = Math.min(this.minCapacity, (long)this.lastCapacity);
    }

    protected int calculateCapacity(int maxCapacity) {
        return 0;
    }

    public final boolean encode(ByteBuffer headerBlock) {
        if (!this.encoding) {
            throw new IllegalStateException("A header hasn't been set up");
        }
        if (!this.prependWithCapacityUpdate(headerBlock)) {
            return false;
        }
        boolean done = this.writer.write(this.headerTable, headerBlock);
        if (done) {
            this.writer.reset();
            this.encoding = false;
        }
        return done;
    }

    private boolean prependWithCapacityUpdate(ByteBuffer headerBlock) {
        if (this.capacityUpdate) {
            boolean done;
            if (!this.configuredCapacityUpdate) {
                LinkedList<Integer> sizes = new LinkedList<Integer>();
                if (this.minCapacity < (long)this.currCapacity) {
                    sizes.add((int)this.minCapacity);
                    if (this.minCapacity != (long)this.lastCapacity) {
                        sizes.add(this.lastCapacity);
                    }
                } else if (this.lastCapacity != this.currCapacity) {
                    sizes.add(this.lastCapacity);
                }
                this.bulkSizeUpdateWriter.maxHeaderTableSizes(sizes);
                this.configuredCapacityUpdate = true;
            }
            if (done = this.bulkSizeUpdateWriter.write(this.headerTable, headerBlock)) {
                this.minCapacity = this.lastCapacity;
                this.currCapacity = this.lastCapacity;
                this.bulkSizeUpdateWriter.reset();
                this.capacityUpdate = false;
                this.configuredCapacityUpdate = false;
            }
            return done;
        }
        return true;
    }

    protected final void indexed(int index) throws IndexOutOfBoundsException {
        this.checkEncoding();
        this.encoding = true;
        this.writer = this.indexedWriter.index(index);
    }

    protected final void literal(int index, CharSequence value, boolean useHuffman) throws IndexOutOfBoundsException {
        this.checkEncoding();
        this.encoding = true;
        this.writer = this.literalWriter.index(index).value(value, useHuffman);
    }

    protected final void literal(CharSequence name, boolean nameHuffman, CharSequence value, boolean valueHuffman) {
        this.checkEncoding();
        this.encoding = true;
        this.writer = this.literalWriter.name(name, nameHuffman).value(value, valueHuffman);
    }

    protected final void literalNeverIndexed(int index, CharSequence value, boolean valueHuffman) throws IndexOutOfBoundsException {
        this.checkEncoding();
        this.encoding = true;
        this.writer = this.literalNeverIndexedWriter.index(index).value(value, valueHuffman);
    }

    protected final void literalNeverIndexed(CharSequence name, boolean nameHuffman, CharSequence value, boolean valueHuffman) {
        this.checkEncoding();
        this.encoding = true;
        this.writer = this.literalNeverIndexedWriter.name(name, nameHuffman).value(value, valueHuffman);
    }

    protected final void literalWithIndexing(int index, CharSequence value, boolean valueHuffman) throws IndexOutOfBoundsException {
        this.checkEncoding();
        this.encoding = true;
        this.writer = this.literalWithIndexingWriter.index(index).value(value, valueHuffman);
    }

    protected final void literalWithIndexing(CharSequence name, boolean nameHuffman, CharSequence value, boolean valueHuffman) {
        this.checkEncoding();
        this.encoding = true;
        this.writer = this.literalWithIndexingWriter.name(name, nameHuffman).value(value, valueHuffman);
    }

    protected final void sizeUpdate(int capacity) throws IllegalArgumentException {
        this.checkEncoding();
        if (capacity > this.maxCapacity) {
            throw new IllegalArgumentException(String.format("capacity <= maxCapacity: capacity=%s, maxCapacity=%s", capacity, this.maxCapacity));
        }
        this.writer = this.sizeUpdateWriter.maxHeaderTableSize(capacity);
    }

    protected final int getMaxCapacity() {
        return this.maxCapacity;
    }

    protected final HeaderTable getHeaderTable() {
        return this.headerTable;
    }

    protected final void checkEncoding() {
        if (this.encoding) {
            throw new IllegalStateException("Previous encoding operation hasn't finished yet");
        }
    }
}

