/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.websocket;

import java.nio.ByteBuffer;
import org.smartboot.http.common.codec.websocket.Decoder;
import org.smartboot.http.common.codec.websocket.MaskingKeyDecoder;
import org.smartboot.http.common.codec.websocket.WebSocket;

class PayloadLengthDecoder
implements Decoder {
    private final Decoder maskingKeyDecoder = new MaskingKeyDecoder();

    PayloadLengthDecoder() {
    }

    @Override
    public Decoder decode(ByteBuffer byteBuffer, WebSocket request) {
        long length = request.getPayloadLength();
        if (length == 126L) {
            if (byteBuffer.remaining() < 2) {
                return this;
            }
            request.setPayloadLength(Short.toUnsignedInt(byteBuffer.getShort()));
        }
        if (length == 127L) {
            if (byteBuffer.remaining() < 8) {
                return this;
            }
            request.setPayloadLength(byteBuffer.getLong());
        }
        return this.maskingKeyDecoder.decode(byteBuffer, request);
    }
}

