/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.utils;

import java.io.File;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smartboot.http.common.logging.Logger;
import org.smartboot.http.common.logging.LoggerFactory;

public class FileReleaseTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileReleaseTracker.class);
    private final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private final Set<FileTracker> trackers = new HashSet<FileTracker>();
    private final Thread reaperThread = new ReaperThread();
    private volatile boolean running = true;

    public FileReleaseTracker() {
        this.reaperThread.setDaemon(true);
        this.reaperThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void track(File file, Object marker) {
        if (file == null || marker == null) {
            throw new IllegalArgumentException("File and marker cannot be null.");
        }
        FileTracker tracker = new FileTracker(file, marker, this.referenceQueue);
        Set<FileTracker> set = this.trackers;
        synchronized (set) {
            this.trackers.add(tracker);
        }
    }

    public void stop() {
        this.running = false;
        this.reaperThread.interrupt();
    }

    public boolean isRunning() {
        return this.running;
    }

    private static class FileTracker
    extends PhantomReference<Object> {
        private final File file;
        private final AtomicBoolean deleteAttempted = new AtomicBoolean(false);

        FileTracker(File file, Object marker, ReferenceQueue<? super Object> queue) {
            super(marker, queue);
            this.file = file;
        }

        public void deleteFile() {
            if (this.deleteAttempted.compareAndSet(false, true) && this.file.exists()) {
                boolean deleted = this.file.delete();
                if (deleted) {
                    LOGGER.info("\u6210\u529f\u5220\u9664\u6587\u4ef6: " + this.file.getAbsolutePath());
                } else {
                    LOGGER.error("\u5220\u9664\u6587\u4ef6\u5931\u8d25: " + this.file.getAbsolutePath());
                }
            }
        }
    }

    private class ReaperThread
    extends Thread {
        private ReaperThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (FileReleaseTracker.this.running) {
                try {
                    FileTracker tracker = (FileTracker)FileReleaseTracker.this.referenceQueue.remove();
                    Set set = FileReleaseTracker.this.trackers;
                    synchronized (set) {
                        FileReleaseTracker.this.trackers.remove(tracker);
                    }
                    tracker.deleteFile();
                }
                catch (InterruptedException e) {
                    if (FileReleaseTracker.this.running) continue;
                    break;
                }
            }
        }
    }
}

