/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.io.IOException;
import java.util.Objects;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HeaderValueEnum;
import org.smartboot.http.common.enums.HttpProtocolEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.exception.HttpException;
import org.smartboot.http.common.io.BufferOutputStream;
import org.smartboot.http.common.logging.Logger;
import org.smartboot.http.common.logging.LoggerFactory;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.Http2ServerHandler;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.HttpServerHandler;
import org.smartboot.http.server.WebSocketHandler;
import org.smartboot.http.server.impl.AbstractResponse;
import org.smartboot.http.server.impl.DecoderUnit;
import org.smartboot.http.server.impl.Request;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.extension.processor.AbstractMessageProcessor;
import org.smartboot.socket.transport.AioSession;

public class HttpMessageProcessor
extends AbstractMessageProcessor<Request> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpMessageProcessor.class);
    private static final int MAX_LENGTH = 261120;
    private HttpServerConfiguration configuration;

    public void process0(AioSession session, Request request) {
        DecoderUnit decodeState = request.getDecodeState();
        try {
            block1 : switch (decodeState.getState()) {
                case 9: {
                    this.doHttpHeader(request);
                    decodeState.setState(12);
                }
                case 12: {
                    decodeState.setState(11);
                    switch (request.getRequestType()) {
                        case HTTP_2: 
                        case HTTP: {
                            request.getServerHandler().onBodyStream(session.readBuffer(), request);
                            break block1;
                        }
                        case WEBSOCKET: {
                            this.configuration.getWebSocketHandler().onBodyStream(session.readBuffer(), request);
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void responseError(AbstractResponse response, Throwable throwable) {
        if (throwable instanceof HttpException) {
            HttpStatus httpStatus = ((HttpException)throwable).getHttpStatus();
            HttpMessageProcessor.responseError(response, httpStatus, httpStatus.getReasonPhrase());
        } else if (throwable.getCause() != null) {
            HttpMessageProcessor.responseError(response, throwable.getCause());
        } else {
            HttpMessageProcessor.responseError(response, HttpStatus.INTERNAL_SERVER_ERROR, throwable.fillInStackTrace().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void responseError(AbstractResponse response, HttpStatus httpStatus, String desc) {
        try {
            if (response.outputStream.request.getAioSession().isInvalid()) {
                return;
            }
            response.setHttpStatus(httpStatus);
            BufferOutputStream outputStream = response.getOutputStream();
            outputStream.write(("<center><h1>" + httpStatus.value() + " " + httpStatus.getReasonPhrase() + "</h1>" + desc + "<hr/><a target='_blank' href='https://smartboot.tech/'>smart-http</a>/" + "2.5.2" + "&nbsp;|&nbsp; <a target='_blank' href='https://gitee.com/smartboot/smart-http'>Gitee</a></center>").getBytes());
        }
        catch (IOException e) {
            LOGGER.warn("HttpError response exception", (Throwable)e);
        }
        finally {
            response.close();
        }
    }

    private void doHttpHeader(Request request) throws IOException {
        this.methodCheck(request);
        this.uriCheck(request);
        if (request.isMultiplexing()) {
            request.getServerHandler().onHeaderComplete(request);
            return;
        }
        if (request.getProtocol() == HttpProtocolEnum.HTTP_2) {
            request.setServerHandler(this.configuration.getHttp2ServerHandler());
        } else {
            String upgrade = request.getHeader(HeaderNameEnum.UPGRADE);
            if (HeaderValueEnum.WEBSOCKET.getName().equalsIgnoreCase(upgrade)) {
                request.setServerHandler(this.configuration.getWebSocketHandler());
            } else if (HeaderValueEnum.H2C.getName().equals(upgrade) || HeaderValueEnum.H2.getName().equals(upgrade)) {
                request.setServerHandler(this.configuration.getHttp2ServerHandler());
            }
        }
        request.getServerHandler().onHeaderComplete(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateEvent0(AioSession session, StateMachineEnum stateMachineEnum, Throwable throwable) {
        switch (stateMachineEnum) {
            case NEW_SESSION: {
                session.setAttachment((Object)new Request(this.configuration, session));
                break;
            }
            case PROCESS_EXCEPTION: {
                LOGGER.error("process exception", throwable);
                session.close();
                break;
            }
            case SESSION_CLOSED: {
                Request request = (Request)session.getAttachment();
                try {
                    if (request.getServerHandler() == null) break;
                    request.getServerHandler().onClose(request);
                    break;
                }
                finally {
                    request.cancelWsIdleTask();
                    request.cancelHttpIdleTask();
                }
            }
            case DECODE_EXCEPTION: {
                AbstractResponse response;
                LOGGER.warn("http decode exception,", throwable);
                Request request = (Request)session.getAttachment();
                switch (request.getRequestType()) {
                    case WEBSOCKET: {
                        response = request.newWebsocketRequest().getResponse();
                        break;
                    }
                    case HTTP: {
                        response = request.newHttpRequest().getResponse();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                HttpMessageProcessor.responseError(response, throwable);
                break;
            }
        }
    }

    public void httpServerHandler(HttpServerHandler httpServerHandler) {
        this.configuration.setHttpServerHandler(Objects.requireNonNull(httpServerHandler));
    }

    public void http2ServerHandler(Http2ServerHandler httpServerHandler) {
        this.configuration.setHttp2ServerHandler(Objects.requireNonNull(httpServerHandler));
    }

    public void setWebSocketHandler(WebSocketHandler webSocketHandler) {
        this.configuration.setWebSocketHandler(Objects.requireNonNull(webSocketHandler));
    }

    private void methodCheck(Request request) {
        if (request.getMethod() == null) {
            throw new HttpException(HttpStatus.NOT_IMPLEMENTED);
        }
    }

    private void hostCheck(Request request) {
        if (request.getHost() == null) {
            throw new HttpException(HttpStatus.BAD_REQUEST);
        }
    }

    private void uriCheck(Request request) {
        String originalUri = request.getUri();
        if (StringUtils.length((CharSequence)originalUri) > 261120) {
            throw new HttpException(HttpStatus.URI_TOO_LONG);
        }
        if (originalUri.charAt(0) == '/') {
            request.setRequestURI(originalUri);
            return;
        }
        int schemeIndex = originalUri.indexOf("://");
        if (schemeIndex > 0) {
            int uriIndex = originalUri.indexOf(47, schemeIndex + 3);
            if (uriIndex == -1) {
                request.setRequestURI("/");
            } else {
                request.setRequestURI(StringUtils.substring((String)originalUri, (int)uriIndex));
            }
            request.setScheme(StringUtils.substring((String)originalUri, (int)0, (int)schemeIndex));
        } else {
            request.setRequestURI(originalUri);
        }
    }

    public void setConfiguration(HttpServerConfiguration configuration) {
        this.configuration = configuration;
    }
}

