/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HeaderValueEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.exception.HttpException;
import org.smartboot.http.common.io.BodyInputStream;
import org.smartboot.http.common.multipart.MultipartConfig;
import org.smartboot.http.common.multipart.Part;
import org.smartboot.http.server.decode.MultipartFormDecoder;
import org.smartboot.http.server.impl.AbstractRequest;
import org.smartboot.http.server.impl.AbstractResponse;
import org.smartboot.http.server.impl.HttpResponseImpl;
import org.smartboot.http.server.impl.Request;

public class HttpRequestImpl
extends AbstractRequest {
    private boolean keepAlive;
    private List<Part> parts;
    private boolean multipartParsed;
    private final HttpResponseImpl response;

    HttpRequestImpl(Request request) {
        this.init(request);
        this.response = new HttpResponseImpl(this);
    }

    @Override
    public final AbstractResponse getResponse() {
        return this.response;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    @Override
    public BodyInputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    @Override
    public Map<String, String> getTrailerFields() {
        return this.request.getTrailerFields() == null ? super.getTrailerFields() : this.request.getTrailerFields();
    }

    @Override
    public boolean isTrailerFieldsReady() {
        return !HeaderValueEnum.CHUNKED.getName().equals(this.getHeader(HeaderNameEnum.TRANSFER_ENCODING)) || this.request.getTrailerFields() != null;
    }

    public void reset() {
        this.request.reset();
        this.response.reset();
        if (this.parts != null) {
            for (Part part : this.parts) {
                try {
                    part.delete();
                }
                catch (IOException iOException) {}
            }
            this.parts = null;
        }
        this.multipartParsed = false;
    }

    @Override
    public Collection<Part> getParts(MultipartConfig configElement) throws IOException {
        if (!this.multipartParsed) {
            MultipartFormDecoder multipartFormDecoder = new MultipartFormDecoder(this, configElement);
            long remaining = this.getContentLength();
            if (configElement.getMaxRequestSize() > 0L && configElement.getMaxRequestSize() < remaining) {
                throw new HttpException(HttpStatus.PAYLOAD_TOO_LARGE);
            }
            int p = this.request.getAioSession().readBuffer().position();
            while (!multipartFormDecoder.decode(this.request.getAioSession().readBuffer(), this)) {
                remaining -= (long)(this.request.getAioSession().readBuffer().position() - p);
                int readSize = this.request.getAioSession().read();
                p = this.request.getAioSession().readBuffer().position();
                if (readSize != -1) continue;
                break;
            }
            this.multipartParsed = true;
            this.request.setInputStream(BodyInputStream.EMPTY_INPUT_STREAM);
            if ((remaining -= (long)(this.request.getAioSession().readBuffer().position() - p)) != 0L) {
                throw new HttpException(HttpStatus.BAD_REQUEST);
            }
        }
        if (this.parts == null) {
            this.parts = new ArrayList<Part>();
        }
        return this.parts;
    }

    public void setPart(Part part) {
        if (this.parts == null) {
            this.parts = new ArrayList<Part>();
        }
        this.parts.add(part);
    }
}

