/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.noear.snack.ONode;
import org.noear.snack.OValue;
import org.noear.snack.OValueType;
import org.noear.snack.core.exts.CharBuffer;
import org.noear.snack.core.exts.CharReader;
import org.noear.snack.core.exts.ThData;
import org.noear.snack.core.exts.TmpCache;
import org.noear.snack.core.utils.StringUtil;

public class JsonPath {
    private static int _cacheSize = 1024;
    private static Map<String, JsonPath> _jpathCache = new HashMap<String, JsonPath>(128);
    private static final ThData<CharBuffer> tlBuilder = new ThData<CharBuffer>(() -> new CharBuffer());
    private static final ThData<TmpCache> tlCache = new ThData<TmpCache>(() -> new TmpCache());
    private List<Segment> segments = new ArrayList<Segment>();
    private static Map<String, Pattern> _regexLib = new HashMap<String, Pattern>();
    private static Resolver handler_$ = (s, root, tmp, usd) -> tmp;
    private static Resolver handler_xx = (s, root, tmp, usd) -> {
        if (s.name.length() > 0) {
            ONode tmp2 = new ONode(root.options()).asArray();
            if ("*".equals(s.name)) {
                JsonPath.scanByAll(s.name, tmp, true, tmp2.ary());
            } else {
                JsonPath.scanByName(s.name, tmp, tmp2.ary());
            }
            if (tmp2.count() > 0) {
                return tmp2;
            }
        }
        return null;
    };
    private static Resolver handler_x = (s, root, tmp, usd) -> {
        ONode tmp2 = null;
        if (tmp.count() > 0) {
            tmp2 = new ONode(tmp.options()).asArray();
            if (tmp.isObject()) {
                tmp2.addAll(tmp.obj().values());
            } else {
                tmp2.addAll(tmp.ary());
            }
        }
        return tmp2;
    };
    private static Resolver handler_prop = (s, root, tmp, usd) -> {
        if (tmp.isObject()) {
            return tmp.getOrNull(s.cmd);
        }
        if (tmp.isArray()) {
            ONode tmp2 = new ONode(tmp.options()).asArray();
            for (ONode n1 : tmp.ary()) {
                ONode n2;
                if (!n1.isObject() || (n2 = n1.nodeData().object.get(s.cmd)) == null) continue;
                tmp2.add(n2);
            }
            return tmp2;
        }
        return null;
    };
    private static Resolver handler_fun = (s, root, tmp, usd) -> {
        switch (s.cmd) {
            case "size()": {
                return new ONode(tmp.options()).val(tmp.count());
            }
            case "length()": {
                if (tmp.isValue()) {
                    return new ONode(tmp.options()).val(tmp.getString().length());
                }
                return new ONode(tmp.options()).val(tmp.count());
            }
            case "min()": {
                if (tmp.isArray()) {
                    ONode min_n = null;
                    for (ONode n1 : tmp.ary()) {
                        if (!n1.isValue()) continue;
                        if (min_n == null) {
                            min_n = n1;
                            continue;
                        }
                        if (!(n1.getDouble() < min_n.getDouble())) continue;
                        min_n = n1;
                    }
                    return min_n;
                }
                return null;
            }
            case "max()": {
                if (tmp.isArray()) {
                    ONode max_n = null;
                    for (ONode n1 : tmp.ary()) {
                        if (!n1.isValue()) continue;
                        if (max_n == null) {
                            max_n = n1;
                            continue;
                        }
                        if (!(n1.getDouble() > max_n.getDouble())) continue;
                        max_n = n1;
                    }
                    return max_n;
                }
                return null;
            }
            case "avg()": {
                if (tmp.isArray()) {
                    double sum = 0.0;
                    int num = 0;
                    for (ONode n1 : tmp.ary()) {
                        if (!n1.isValue()) continue;
                        sum += n1.getDouble();
                        ++num;
                    }
                    if (num > 0) {
                        return new ONode(tmp.options()).val(sum / (double)num);
                    }
                }
                return null;
            }
            case "sum()": {
                if (tmp.isArray()) {
                    double sum = 0.0;
                    for (ONode n1 : tmp.ary()) {
                        sum += n1.getDouble();
                    }
                    return new ONode(tmp.options()).val(sum);
                }
                return null;
            }
        }
        return null;
    };
    private static Resolver handler_ary_x = (s, root, tmp, usd) -> {
        ONode tmp2 = null;
        if (tmp.isArray()) {
            tmp2 = tmp;
        }
        if (tmp.isObject()) {
            tmp2 = new ONode(tmp.options()).asArray();
            tmp2.addAll(tmp.obj().values());
        }
        return tmp2;
    };
    private static Resolver handler_ary_exp = (s, root, tmp, usd) -> {
        ONode tmp2 = tmp;
        if (s.op == null) {
            if (tmp.isObject()) {
                if (JsonPath.do_get(tmp, s.left, true, usd).isNull()) {
                    return null;
                }
            } else if (tmp.isArray()) {
                tmp2 = new ONode(tmp.options()).asArray();
                for (ONode n1 : tmp.ary()) {
                    if (JsonPath.do_get(n1, s.left, true, usd).isNull()) continue;
                    tmp2.nodeData().array.add(n1);
                }
            }
        } else if (tmp.isObject()) {
            if ("@".equals(s.left)) {
                return null;
            }
            ONode leftO = JsonPath.do_get(tmp, s.left, true, usd);
            if (!JsonPath.compare(root, tmp, leftO, s.op, s.right, usd)) {
                return null;
            }
        } else if (tmp.isArray()) {
            tmp2 = new ONode(tmp.options()).asArray();
            if ("@".equals(s.left)) {
                for (ONode n1 : tmp.ary()) {
                    if (!JsonPath.compare(root, n1, n1, s.op, s.right, usd)) continue;
                    tmp2.addNode(n1);
                }
            } else {
                for (ONode n1 : tmp.ary()) {
                    ONode leftO;
                    if (!JsonPath.compare(root, n1, leftO = JsonPath.do_get(n1, s.left, true, usd), s.op, s.right, usd)) continue;
                    tmp2.addNode(n1);
                }
            }
        } else if (tmp.isValue() && "@".equals(s.left) && !JsonPath.compare(root, tmp, tmp, s.op, s.right, usd)) {
            return null;
        }
        return tmp2;
    };
    private static Resolver handler_ary_ref = (s, root, tmp, usd) -> {
        ONode tmp2 = null;
        if (tmp.isObject()) {
            tmp2 = s.cmdAry.startsWith("$") ? JsonPath.do_get(root, s.cmdAry, true, usd) : JsonPath.do_get(tmp, s.cmdAry, true, usd);
            tmp2 = tmp2.isValue() ? tmp.get(tmp2.getString()) : null;
        }
        return tmp2;
    };
    private static Resolver handler_ary_multi = (s, root, tmp, usd) -> {
        ONode tmp2;
        block9: {
            block8: {
                tmp2 = null;
                if (s.cmdAry.indexOf("'") < 0) break block8;
                if (tmp.isObject()) {
                    for (String k : s.nameS) {
                        ONode n1 = tmp.obj().get(k);
                        if (n1 == null) continue;
                        if (tmp2 == null) {
                            tmp2 = new ONode(tmp.options()).asArray();
                        }
                        tmp2.addNode(n1);
                    }
                }
                if (!tmp.isArray()) break block9;
                tmp2 = new ONode(tmp.options()).asArray();
                for (ONode tmp1 : tmp.ary()) {
                    if (!tmp1.isObject()) continue;
                    for (String k : s.nameS) {
                        ONode n1 = tmp1.obj().get(k);
                        if (n1 == null) continue;
                        tmp2.addNode(n1);
                    }
                }
                break block9;
            }
            if (tmp.isArray()) {
                List<ONode> list2 = tmp.nodeData().array;
                int len2 = list2.size();
                for (int idx : s.indexS) {
                    if (idx < 0 || idx >= len2) continue;
                    if (tmp2 == null) {
                        tmp2 = new ONode(tmp.options()).asArray();
                    }
                    tmp2.addNode(list2.get(idx));
                }
            }
        }
        return tmp2;
    };
    private static Resolver handler_ary_range = (s, root, tmp, usd) -> {
        if (tmp.isArray()) {
            int count = tmp.count();
            int start = s.start;
            int end = s.end;
            if (start < 0) {
                start = count + start;
            }
            if (end == 0) {
                end = count;
            }
            if (end < 0) {
                end = count + end;
            }
            if (start < 0) {
                start = 0;
            }
            if (end > count) {
                end = count;
            }
            return new ONode(tmp.options()).addAll(tmp.ary().subList(start, end));
        }
        return null;
    };
    private static Resolver handler_ary_prop = (s, root, tmp, usd) -> {
        if (s.cmdHasQuote) {
            if (tmp.isObject()) {
                return tmp.getOrNull(s.name);
            }
            if (tmp.isArray()) {
                ONode tmp2 = new ONode(tmp.options()).asArray();
                for (ONode n1 : tmp.ary()) {
                    ONode n2;
                    if (!n1.isObject() || (n2 = n1.nodeData().object.get(s.name)) == null) continue;
                    tmp2.add(n2);
                }
                return tmp2;
            }
            return null;
        }
        if (s.start < 0) {
            return tmp.getOrNull(tmp.count() + s.start);
        }
        return tmp.getOrNull(s.start);
    };

    public static ONode eval(ONode source, String jpath, boolean useStandard, boolean cacheJpath) {
        ((TmpCache)tlCache.get()).clear();
        return JsonPath.do_get(source, jpath, cacheJpath, useStandard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ONode do_get(ONode source, String jpath, boolean cacheJpath, boolean useStandard) {
        JsonPath jsonPath = null;
        if (cacheJpath) {
            jsonPath = _jpathCache.get(jpath);
            if (jsonPath == null) {
                String string = jpath.intern();
                synchronized (string) {
                    jsonPath = _jpathCache.get(jpath);
                    if (jsonPath == null) {
                        jsonPath = JsonPath.compile(jpath);
                        if (_jpathCache.size() < _cacheSize) {
                            _jpathCache.put(jpath, jsonPath);
                        }
                    }
                }
            }
        } else {
            jsonPath = JsonPath.compile(jpath);
        }
        return JsonPath.exec(jsonPath, source, useStandard);
    }

    private JsonPath() {
    }

    private static JsonPath compile(String jpath) {
        String jpath2 = jpath.replace("..", "._");
        JsonPath jsonPath = new JsonPath();
        int token = 0;
        char c = '\u0000';
        CharBuffer buffer = (CharBuffer)tlBuilder.get();
        buffer.setLength(0);
        CharReader reader = new CharReader(jpath2);
        block7: while (true) {
            if ((c = reader.next()) == '\u0000') {
                if (buffer.length() <= 0) break;
                jsonPath.segments.add(new Segment(buffer.toString()));
                buffer.clear();
                break;
            }
            switch (c) {
                case '.': {
                    if (token > 0) {
                        buffer.append(c);
                        continue block7;
                    }
                    if (buffer.length() <= 0) continue block7;
                    jsonPath.segments.add(new Segment(buffer.toString()));
                    buffer.clear();
                    continue block7;
                }
                case '(': {
                    if (token == 91) {
                        token = c;
                    }
                    buffer.append(c);
                    continue block7;
                }
                case ')': {
                    if (token == 40) {
                        token = c;
                    }
                    buffer.append(c);
                    continue block7;
                }
                case '[': {
                    if (token == 0) {
                        token = c;
                        if (buffer.length() <= 0) continue block7;
                        jsonPath.segments.add(new Segment(buffer.toString()));
                        buffer.clear();
                        continue block7;
                    }
                    buffer.append(c);
                    continue block7;
                }
                case ']': {
                    if (token == 91 || token == 41) {
                        token = 0;
                        buffer.append(c);
                        if (buffer.length() <= 0) continue block7;
                        jsonPath.segments.add(new Segment(buffer.toString()));
                        buffer.clear();
                        continue block7;
                    }
                    buffer.append(c);
                    continue block7;
                }
            }
            buffer.append(c);
        }
        return jsonPath;
    }

    private static ONode exec(JsonPath jsonPath, ONode source, boolean useStandard) {
        ONode tmp = source;
        boolean branch_do = false;
        for (Segment s : jsonPath.segments) {
            if (tmp == null) break;
            if (branch_do && (useStandard || s.cmdAry != null)) {
                ONode tmp2 = new ONode(source.options()).asArray();
                Consumer<ONode> act1 = n1 -> {
                    ONode n2 = s.handler.run(s, source, (ONode)n1, useStandard);
                    if (n2 != null) {
                        if (s.cmdAry != null) {
                            if (n2.isArray()) {
                                tmp2.addAll(n2.ary());
                            } else {
                                tmp2.addNode(n2);
                            }
                        } else {
                            tmp2.addNode(n2);
                        }
                    }
                };
                tmp.ary().forEach(act1);
                tmp = tmp2;
                if (useStandard) continue;
                branch_do = false;
                continue;
            }
            tmp = s.handler.run(s, source, tmp, useStandard);
            branch_do = s.cmdHasUnline;
        }
        if (tmp == null) {
            return new ONode(source.options());
        }
        return tmp;
    }

    private static void scanByName(String name, ONode source, List<ONode> target) {
        if (source.isObject()) {
            for (Map.Entry<String, ONode> kv : source.obj().entrySet()) {
                if (name.equals(kv.getKey())) {
                    target.add(kv.getValue());
                }
                JsonPath.scanByName(name, kv.getValue(), target);
            }
            return;
        }
        if (source.isArray()) {
            for (ONode n1 : source.ary()) {
                JsonPath.scanByName(name, n1, target);
            }
            return;
        }
    }

    private static void scanByAll(String name, ONode source, boolean isRoot, List<ONode> target) {
        if (!isRoot) {
            target.add(source);
        }
        if (source.isObject()) {
            for (Map.Entry<String, ONode> kv : source.obj().entrySet()) {
                JsonPath.scanByAll(name, kv.getValue(), false, target);
            }
            return;
        }
        if (source.isArray()) {
            for (ONode n1 : source.ary()) {
                JsonPath.scanByAll(name, n1, false, target);
            }
            return;
        }
    }

    private static boolean compare(ONode root, ONode parent, ONode leftO, String op, String right, boolean useStandard) {
        if (leftO == null) {
            return false;
        }
        if (!leftO.isValue() || leftO.val().isNull()) {
            return false;
        }
        OValue left = leftO.val();
        ONode rightO = null;
        if (right.startsWith("$") && (rightO = (ONode)((TmpCache)tlCache.get()).get(right)) == null) {
            rightO = JsonPath.do_get(root, right, true, useStandard);
            ((TmpCache)tlCache.get()).put(right, rightO);
        }
        if (right.startsWith("@")) {
            rightO = JsonPath.do_get(parent, right, true, useStandard);
        }
        if (rightO != null) {
            right = rightO.isValue() ? (rightO.val().type() == OValueType.String ? "'" + rightO.getString() + "'" : rightO.getDouble() + "") : null;
        }
        switch (op) {
            case "==": {
                if (right == null) {
                    return false;
                }
                if (right.startsWith("'")) {
                    return left.getString().equals(right.substring(1, right.length() - 1));
                }
                return left.getDouble() == Double.parseDouble(right);
            }
            case "!=": {
                if (right == null) {
                    return false;
                }
                if (right.startsWith("'")) {
                    return !left.getString().equals(right.substring(1, right.length() - 1));
                }
                return left.getDouble() != Double.parseDouble(right);
            }
            case "<": {
                if (right == null) {
                    return false;
                }
                return left.getDouble() < Double.parseDouble(right);
            }
            case "<=": {
                if (right == null) {
                    return false;
                }
                return left.getDouble() <= Double.parseDouble(right);
            }
            case ">": {
                if (right == null) {
                    return false;
                }
                return left.getDouble() > Double.parseDouble(right);
            }
            case ">=": {
                if (right == null) {
                    return false;
                }
                return left.getDouble() >= Double.parseDouble(right);
            }
            case "=~": {
                if (right == null) {
                    return false;
                }
                int end = right.lastIndexOf(47);
                String exp = right.substring(1, end);
                return JsonPath.regex(right, exp).matcher(left.getString()).find();
            }
            case "in": {
                if (right == null) {
                    Object val = left.getRaw();
                    for (ONode n1 : rightO.ary()) {
                        if (!n1.val().getRaw().equals(val)) continue;
                        return true;
                    }
                    return false;
                }
                if (right.indexOf("'") > 0) {
                    return JsonPath.getStringAry(right).contains(left.getString());
                }
                return JsonPath.getDoubleAry(right).contains(left.getDouble());
            }
            case "nin": {
                if (right == null) {
                    Object val = left.getRaw();
                    for (ONode n1 : rightO.ary()) {
                        if (!n1.val().getRaw().equals(val)) continue;
                        return false;
                    }
                    return true;
                }
                if (right.indexOf("'") > 0) {
                    return !JsonPath.getStringAry(right).contains(left.getString());
                }
                return !JsonPath.getDoubleAry(right).contains(left.getDouble());
            }
        }
        return false;
    }

    private static List<String> getStringAry(String text) {
        String[] ss;
        ArrayList<String> ary = new ArrayList<String>();
        String test2 = text.substring(1, text.length() - 1);
        for (String s : ss = test2.split(",")) {
            ary.add(s.substring(1, s.length() - 1));
        }
        return ary;
    }

    private static List<Double> getDoubleAry(String text) {
        String[] ss;
        ArrayList<Double> ary = new ArrayList<Double>();
        String test2 = text.substring(1, text.length() - 1);
        for (String s : ss = test2.split(",")) {
            ary.add(Double.parseDouble(s));
        }
        return ary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pattern regex(String exprFull, String expr) {
        Pattern p = _regexLib.get(exprFull);
        if (p == null) {
            String string = exprFull.intern();
            synchronized (string) {
                if (p == null) {
                    p = exprFull.endsWith("i") ? Pattern.compile(expr, 2) : Pattern.compile(expr);
                    _regexLib.put(exprFull, p);
                }
            }
        }
        return p;
    }

    private static class Segment {
        public String cmd;
        public String cmdAry;
        public boolean cmdHasQuote;
        public boolean cmdHasUnline;
        public List<Integer> indexS;
        public List<String> nameS;
        public String name;
        public int start = 0;
        public int end = 0;
        public String left;
        public String op;
        public String right;
        public Resolver handler;

        public Segment(String test) {
            this.cmd = test.trim();
            this.cmdHasQuote = this.cmd.indexOf("'") >= 0;
            this.cmdHasUnline = this.cmd.startsWith("_");
            if (this.cmdHasUnline) {
                this.name = this.cmd.substring(1);
            }
            if (this.cmd.endsWith("]")) {
                this.cmdAry = this.cmd.substring(0, this.cmd.length() - 1).trim();
                if (this.cmdAry.startsWith("?")) {
                    String s2 = this.cmdAry.substring(2, this.cmdAry.length() - 1);
                    String[] ss2 = s2.split(" ");
                    this.left = ss2[0];
                    if (ss2.length == 3) {
                        this.op = ss2[1];
                        this.right = ss2[2];
                    }
                } else if (this.cmdAry.indexOf(":") >= 0) {
                    String[] iAry = this.cmdAry.split(":", -1);
                    this.start = 0;
                    if (iAry[0].length() > 0) {
                        this.start = Integer.parseInt(iAry[0]);
                    }
                    this.end = 0;
                    if (iAry[1].length() > 0) {
                        this.end = Integer.parseInt(iAry[1]);
                    }
                } else if (this.cmdAry.indexOf(",") > 0) {
                    if (this.cmdAry.indexOf("'") >= 0) {
                        String[] iAry;
                        this.nameS = new ArrayList<String>();
                        for (String i1 : iAry = this.cmdAry.split(",")) {
                            i1 = i1.trim();
                            this.nameS.add(i1.substring(1, i1.length() - 1));
                        }
                    } else {
                        String[] iAry;
                        this.indexS = new ArrayList<Integer>();
                        for (String i1 : iAry = this.cmdAry.split(",")) {
                            i1 = i1.trim();
                            this.indexS.add(Integer.parseInt(i1));
                        }
                    }
                } else if (this.cmdAry.indexOf("'") >= 0) {
                    this.name = this.cmdAry.substring(1, this.cmdAry.length() - 1);
                } else if (StringUtil.isInteger(this.cmdAry)) {
                    this.start = Integer.parseInt(this.cmdAry);
                }
            }
            if ("$".equals(this.cmd) || "@".equals(this.cmd)) {
                this.handler = handler_$;
                return;
            }
            if (this.cmd.startsWith("_")) {
                this.handler = handler_xx;
                return;
            }
            if ("*".equals(this.cmd)) {
                this.handler = handler_x;
                return;
            }
            if (this.cmd.endsWith("]")) {
                if ("*".equals(this.cmdAry)) {
                    this.handler = handler_ary_x;
                    return;
                }
                this.handler = this.cmd.startsWith("?") ? handler_ary_exp : (this.cmdAry.indexOf(",") > 0 ? handler_ary_multi : (this.cmdAry.indexOf(":") >= 0 ? handler_ary_range : (this.cmdAry.startsWith("$.") || this.cmdAry.startsWith("@.") ? handler_ary_ref : handler_ary_prop)));
            } else {
                this.handler = this.cmd.endsWith(")") ? handler_fun : handler_prop;
            }
        }

        public int length() {
            return this.cmd.length();
        }

        public String toString() {
            return this.cmd;
        }
    }

    @FunctionalInterface
    private static interface Resolver {
        public ONode run(Segment var1, ONode var2, ONode var3, Boolean var4);
    }
}

