/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.to;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;
import org.noear.snack.ONode;
import org.noear.snack.ONodeData;
import org.noear.snack.OValue;
import org.noear.snack.core.Context;
import org.noear.snack.core.Feature;
import org.noear.snack.core.Options;
import org.noear.snack.core.exts.ThData;
import org.noear.snack.core.utils.DateUtil;
import org.noear.snack.core.utils.IOUtil;
import org.noear.snack.core.utils.TypeUtil;
import org.noear.snack.to.Toer;

public class JsonToer
implements Toer {
    private static final ThData<StringBuilder> tlBuilder = new ThData<Object>(() -> new StringBuilder(5120));

    @Override
    public void handle(Context ctx) {
        ONode o = (ONode)ctx.source;
        if (null != o) {
            StringBuilder sb = null;
            if (ctx.options.hasFeature(Feature.DisThreadLocal)) {
                sb = new StringBuilder(5120);
            } else {
                sb = (StringBuilder)tlBuilder.get();
                sb.setLength(0);
            }
            this.analyse(ctx.options, o, sb);
            ctx.target = sb.toString();
        }
    }

    public void analyse(Options opts, ONode o, StringBuilder sb) {
        if (o == null) {
            return;
        }
        switch (o.nodeType()) {
            case Value: {
                this.writeValue(opts, sb, o.nodeData());
                break;
            }
            case Array: {
                this.writeArray(opts, sb, o.nodeData());
                break;
            }
            case Object: {
                this.writeObject(opts, sb, o.nodeData());
                break;
            }
            default: {
                sb.append("null");
            }
        }
    }

    private void writeArray(Options opts, StringBuilder sBuf, ONodeData d) {
        sBuf.append("[");
        Iterator<ONode> iterator = d.array.iterator();
        while (iterator.hasNext()) {
            ONode sub = iterator.next();
            this.analyse(opts, sub, sBuf);
            if (!iterator.hasNext()) continue;
            sBuf.append(",");
        }
        sBuf.append("]");
    }

    private void writeObject(Options opts, StringBuilder sBuf, ONodeData d) {
        sBuf.append("{");
        Iterator<String> itr = d.object.keySet().iterator();
        while (itr.hasNext()) {
            String k = itr.next();
            this.writeName(opts, sBuf, k);
            sBuf.append(":");
            this.analyse(opts, d.object.get(k), sBuf);
            if (!itr.hasNext()) continue;
            sBuf.append(",");
        }
        sBuf.append("}");
    }

    private void writeValue(Options opts, StringBuilder sBuf, ONodeData d) {
        OValue v = d.value;
        switch (v.type()) {
            case Null: {
                sBuf.append("null");
                break;
            }
            case String: {
                this.writeValString(opts, sBuf, v.getRawString(), true);
                break;
            }
            case DateTime: {
                this.writeValDate(opts, sBuf, v.getRawDate());
                break;
            }
            case Boolean: {
                this.writeValBool(opts, sBuf, v.getRawBoolean());
                break;
            }
            case Number: {
                this.writeValNumber(opts, sBuf, v.getRawNumber());
                break;
            }
            default: {
                sBuf.append(v.getString());
            }
        }
    }

    private void writeName(Options opts, StringBuilder sBuf, String val) {
        if (opts.hasFeature(Feature.QuoteFieldNames)) {
            if (opts.hasFeature(Feature.UseSingleQuotes)) {
                sBuf.append("'").append(val).append("'");
            } else {
                sBuf.append("\"").append(val).append("\"");
            }
        } else {
            sBuf.append(val);
        }
    }

    private void writeValDate(Options opts, StringBuilder sBuf, Date val) {
        if (opts.hasFeature(Feature.WriteDateUseTicks)) {
            sBuf.append(val.getTime());
        } else if (opts.hasFeature(Feature.WriteDateUseFormat)) {
            String valStr = DateUtil.format(val, opts.getDateFormat(), opts.getTimeZone());
            this.writeValString(opts, sBuf, valStr, false);
        } else {
            sBuf.append("new Date(").append(val.getTime()).append(")");
        }
    }

    private void writeValBool(Options opts, StringBuilder sBuf, Boolean val) {
        if (opts.hasFeature(Feature.WriteBoolUse01)) {
            sBuf.append(val != false ? 1 : 0);
        } else {
            sBuf.append(val != false ? "true" : "false");
        }
    }

    private void writeValNumber(Options opts, StringBuilder sBuf, Number val) {
        if (val instanceof BigInteger) {
            BigInteger v = (BigInteger)val;
            String sVal = v.toString();
            if (opts.hasFeature(Feature.WriteNumberUseString)) {
                this.writeValString(opts, sBuf, sVal, false);
            } else if (sVal.length() > 16 && (v.compareTo(TypeUtil.INT_LOW) < 0 || v.compareTo(TypeUtil.INT_HIGH) > 0) && opts.hasFeature(Feature.BrowserCompatible)) {
                this.writeValString(opts, sBuf, sVal, false);
            } else {
                sBuf.append(sVal);
            }
            return;
        }
        if (val instanceof BigDecimal) {
            BigDecimal v = (BigDecimal)val;
            String sVal = v.toPlainString();
            if (opts.hasFeature(Feature.WriteNumberUseString)) {
                this.writeValString(opts, sBuf, sVal, false);
            } else if (sVal.length() > 16 && (v.compareTo(TypeUtil.DEC_LOW) < 0 || v.compareTo(TypeUtil.DEC_HIGH) > 0) && opts.hasFeature(Feature.BrowserCompatible)) {
                this.writeValString(opts, sBuf, sVal, false);
            } else {
                sBuf.append(sVal);
            }
            return;
        }
        if (opts.hasFeature(Feature.WriteNumberUseString)) {
            this.writeValString(opts, sBuf, val.toString(), false);
        } else {
            sBuf.append(val.toString());
        }
    }

    private void writeValString(Options opts, StringBuilder sBuf, String val, boolean isStr) {
        boolean useSingleQuotes = opts.hasFeature(Feature.UseSingleQuotes);
        char quote = useSingleQuotes ? (char)'\'' : '\"';
        sBuf.append(quote);
        if (isStr) {
            boolean isCompatible = opts.hasFeature(Feature.BrowserCompatible);
            boolean isSecure = opts.hasFeature(Feature.BrowserSecure);
            boolean isTransfer = opts.hasFeature(Feature.TransferCompatible);
            int len = val.length();
            for (int i = 0; i < len; ++i) {
                char c = val.charAt(i);
                if (c == quote || c == '\n' || c == '\r' || c == '\t' || c == '\f' || c == '\b' || c >= '\u0000' && c <= '\u0007') {
                    sBuf.append("\\");
                    sBuf.append(IOUtil.CHARS_MARK[c]);
                    continue;
                }
                if (isSecure && (c == '(' || c == ')' || c == '<' || c == '>')) {
                    sBuf.append('\\');
                    sBuf.append('u');
                    sBuf.append(IOUtil.DIGITS[c >>> 12 & 0xF]);
                    sBuf.append(IOUtil.DIGITS[c >>> 8 & 0xF]);
                    sBuf.append(IOUtil.DIGITS[c >>> 4 & 0xF]);
                    sBuf.append(IOUtil.DIGITS[c & 0xF]);
                    continue;
                }
                if (isTransfer && c == '\\') {
                    sBuf.append("\\");
                    sBuf.append(IOUtil.CHARS_MARK[c]);
                    continue;
                }
                if (isCompatible) {
                    if (c == '\\') {
                        sBuf.append("\\");
                        sBuf.append(IOUtil.CHARS_MARK[c]);
                        continue;
                    }
                    if (c < ' ') {
                        sBuf.append('\\');
                        sBuf.append('u');
                        sBuf.append('0');
                        sBuf.append('0');
                        sBuf.append(IOUtil.DIGITS[c >>> 4 & 0xF]);
                        sBuf.append(IOUtil.DIGITS[c & 0xF]);
                        continue;
                    }
                    if (c >= '\u007f') {
                        sBuf.append('\\');
                        sBuf.append('u');
                        sBuf.append(IOUtil.DIGITS[c >>> 12 & 0xF]);
                        sBuf.append(IOUtil.DIGITS[c >>> 8 & 0xF]);
                        sBuf.append(IOUtil.DIGITS[c >>> 4 & 0xF]);
                        sBuf.append(IOUtil.DIGITS[c & 0xF]);
                        continue;
                    }
                }
                sBuf.append(c);
            }
        } else {
            sBuf.append(val);
        }
        sBuf.append(quote);
    }
}

