/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.from;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.noear.snack.ONode;
import org.noear.snack.OValue;
import org.noear.snack.core.Context;
import org.noear.snack.core.Feature;
import org.noear.snack.core.exts.CharBuffer;
import org.noear.snack.core.exts.CharReader;
import org.noear.snack.core.exts.ThData;
import org.noear.snack.core.utils.IOUtil;
import org.noear.snack.exception.SnackException;
import org.noear.snack.from.Fromer;

public class JsonFromer
implements Fromer {
    private static final ThData<CharBuffer> tlBuilder = new ThData<CharBuffer>(() -> new CharBuffer());

    @Override
    public void handle(Context ctx) throws IOException {
        ctx.target = this.do_handle(ctx, (String)ctx.source);
    }

    private ONode do_handle(Context ctx, String text) throws IOException {
        ONode node;
        if (text == null) {
            return new ONode(ctx.options);
        }
        int len = (text = text.trim()).length();
        if (len == 0) {
            node = new ONode(ctx.options);
        } else {
            char prefix = text.charAt(0);
            char suffix = text.charAt(text.length() - 1);
            if (prefix == '{' && suffix == '}' || prefix == '[' && suffix == ']') {
                CharBuffer sBuf = null;
                if (ctx.options.hasFeature(Feature.DisThreadLocal)) {
                    sBuf = new CharBuffer();
                } else {
                    sBuf = (CharBuffer)tlBuilder.get();
                    sBuf.setLength(0);
                }
                node = new ONode(ctx.options);
                this.analyse(ctx, new CharReader(text), sBuf, node);
            } else if (len >= 2 && (prefix == '\"' && suffix == '\"' || prefix == '\'' && suffix == '\'')) {
                node = this.analyse_val(ctx, text.substring(1, len - 1), true, false);
            } else if (prefix != '<' && len < 40) {
                node = this.analyse_val(ctx, text, false, true);
            } else {
                node = new ONode(ctx.options);
                node.val().setString(text);
            }
        }
        return node;
    }

    public void analyse(Context ctx, CharReader sr, CharBuffer sBuf, ONode p) throws IOException {
        String name = null;
        boolean read_space1 = false;
        block10: while (sr.read()) {
            char c = sr.value();
            switch (c) {
                case '\"': {
                    this.scanString(sr, sBuf, '\"');
                    if (!this.analyse_buf(ctx, p, name, sBuf)) continue block10;
                    name = null;
                    continue block10;
                }
                case '\'': {
                    this.scanString(sr, sBuf, '\'');
                    if (!this.analyse_buf(ctx, p, name, sBuf)) continue block10;
                    name = null;
                    continue block10;
                }
                case '{': {
                    if (p.isObject()) {
                        this.analyse(ctx, sr, sBuf, p.getNew(name).asObject());
                        name = null;
                        continue block10;
                    }
                    if (p.isArray()) {
                        this.analyse(ctx, sr, sBuf, p.addNew().asObject());
                        continue block10;
                    }
                    this.analyse(ctx, sr, sBuf, p.asObject());
                    continue block10;
                }
                case '[': {
                    if (p.isObject()) {
                        this.analyse(ctx, sr, sBuf, p.getNew(name).asArray());
                        name = null;
                        continue block10;
                    }
                    if (p.isArray()) {
                        this.analyse(ctx, sr, sBuf, p.addNew().asArray());
                        continue block10;
                    }
                    this.analyse(ctx, sr, sBuf, p.asArray());
                    continue block10;
                }
                case ':': {
                    name = sBuf.toString();
                    sBuf.setLength(0);
                    continue block10;
                }
                case ',': {
                    if (sBuf.length() <= 0 || !this.analyse_buf(ctx, p, name, sBuf)) continue block10;
                    name = null;
                    continue block10;
                }
                case '}': {
                    if (sBuf.length() > 0) {
                        this.analyse_buf(ctx, p, name, sBuf);
                    }
                    return;
                }
                case ']': {
                    if (sBuf.length() > 0) {
                        this.analyse_buf(ctx, p, name, sBuf);
                    }
                    return;
                }
            }
            if (sBuf.length() == 0) {
                if (c <= ' ') continue;
                sBuf.append(c);
                if (c != 'n') continue;
                read_space1 = true;
                continue;
            }
            if (c > ' ') {
                sBuf.append(c);
                continue;
            }
            if (c != ' ' || !read_space1) continue;
            read_space1 = false;
            if (sBuf.isString) continue;
            sBuf.append(c);
        }
    }

    private boolean analyse_buf(Context ctx, ONode p, String name, CharBuffer sBuf) {
        if (p.isObject()) {
            if (name != null) {
                p.setNode(name, this.analyse_val(ctx, sBuf));
                sBuf.setLength(0);
                return true;
            }
        } else if (p.isArray()) {
            p.addNode(this.analyse_val(ctx, sBuf));
            sBuf.setLength(0);
        }
        return false;
    }

    private void scanString(CharReader sr, CharBuffer sBuf, char quote) throws IOException {
        sBuf.isString = true;
        while (sr.read()) {
            char c = sr.value();
            if (quote == c) {
                return;
            }
            if ('\\' == c) {
                c = sr.next();
                if ('t' == c || 'r' == c || 'n' == c || 'f' == c || 'b' == c || '\"' == c || '\'' == c || '/' == c || '\\' == c || c >= '0' && c <= '7') {
                    sBuf.append(IOUtil.CHARS_MARK_REV[c]);
                    continue;
                }
                if ('x' == c) {
                    char x1 = sr.next();
                    char x2 = sr.next();
                    int val = IOUtil.DIGITS_MARK[x1] * 16 + IOUtil.DIGITS_MARK[x2];
                    sBuf.append((char)val);
                    continue;
                }
                if ('u' == c) {
                    int val = 0;
                    c = sr.next();
                    val = (val << 4) + IOUtil.DIGITS_MARK[c];
                    c = sr.next();
                    val = (val << 4) + IOUtil.DIGITS_MARK[c];
                    c = sr.next();
                    val = (val << 4) + IOUtil.DIGITS_MARK[c];
                    c = sr.next();
                    val = (val << 4) + IOUtil.DIGITS_MARK[c];
                    sBuf.append((char)val);
                    continue;
                }
                sBuf.append('\\');
                sBuf.append(c);
                continue;
            }
            sBuf.append(c);
        }
    }

    private ONode analyse_val(Context ctx, CharBuffer sBuf) {
        if (!sBuf.isString) {
            sBuf.trimLast();
        }
        return this.analyse_val(ctx, sBuf.toString(), sBuf.isString, false);
    }

    private ONode analyse_val(Context ctx, String sval, boolean isString, boolean isNoterr) {
        ONode orst = null;
        if (isString) {
            if (ctx.options.hasFeature(Feature.StringJsonToNode) && (sval.startsWith("{") && sval.endsWith("}") || sval.startsWith("[") && sval.endsWith("]"))) {
                orst = ONode.loadStr(sval, ctx.options);
            }
            if (orst == null) {
                orst = new ONode(ctx.options);
                orst.val().setString(sval);
            }
        } else {
            orst = new ONode(ctx.options);
            OValue oval = orst.val();
            char c = sval.charAt(0);
            int len = sval.length();
            if (c == 't' && len == 4) {
                oval.setBool(true);
            } else if (c == 'f' && len == 5) {
                oval.setBool(false);
            } else if (c == 'n') {
                if (len == 4) {
                    oval.setNull();
                } else if (sval.indexOf(68) == 4) {
                    long ticks = Long.parseLong(sval.substring(9, sval.length() - 1));
                    oval.setDate(new Date(ticks));
                }
            } else if (c == 'N' && len == 3) {
                oval.setNull();
            } else if (c == 'u' && len == 9) {
                oval.setNull();
            } else if (c >= '0' && c <= '9' || c == '-') {
                if (sval.length() > 16) {
                    if (sval.indexOf(46) > 0) {
                        oval.setNumber(new BigDecimal(sval));
                    } else {
                        oval.setNumber(new BigInteger(sval));
                    }
                } else if (sval.indexOf(46) > 0) {
                    if (ctx.options.hasFeature(Feature.StringDoubleToDecimal)) {
                        oval.setNumber(new BigDecimal(sval));
                    } else {
                        oval.setNumber(Double.parseDouble(sval));
                    }
                } else {
                    Long sval2 = Long.parseLong(sval);
                    if (sval2 > Integer.MAX_VALUE || ctx.options.hasFeature(Feature.ParseIntegerUseLong)) {
                        oval.setNumber(sval2);
                    } else {
                        oval.setNumber(sval2.intValue());
                    }
                }
            } else if (isNoterr) {
                oval.setString(sval);
            } else {
                throw new SnackException("Format error!");
            }
        }
        return orst;
    }
}

