/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation.annotation;

import java.util.Collection;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.validation.Validator;
import org.noear.solon.validation.annotation.NotEmpty;

public class NotEmptyValidator
implements Validator<NotEmpty> {
    public static final NotEmptyValidator instance = new NotEmptyValidator();

    @Override
    public String message(NotEmpty anno) {
        return anno.message();
    }

    @Override
    public Class<?>[] groups(NotEmpty anno) {
        return anno.groups();
    }

    @Override
    public boolean isSupportValueType(Class<?> type) {
        return String.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type);
    }

    @Override
    public Result validateOfValue(NotEmpty anno, Object val0, StringBuilder tmp) {
        if (val0 instanceof String) {
            String val = (String)val0;
            if (Utils.isEmpty((String)val)) {
                return Result.failure();
            }
            return Result.succeed();
        }
        if (val0 instanceof Collection) {
            Collection val = (Collection)val0;
            if (val.size() == 0) {
                return Result.failure();
            }
            return Result.succeed();
        }
        return Result.failure();
    }

    @Override
    public Result validateOfContext(Context ctx, NotEmpty anno, String name, StringBuilder tmp) {
        if (name == null) {
            for (String key : anno.value()) {
                if (!Utils.isEmpty((String)ctx.param(key))) continue;
                tmp.append(',').append(key);
            }
        } else if (Utils.isEmpty((String)ctx.param(name))) {
            tmp.append(',').append(name);
        }
        if (tmp.length() > 1) {
            return Result.failure((String)tmp.substring(1));
        }
        return Result.succeed();
    }
}

