/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.socketd;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.core.message.Session;
import org.noear.solon.socketd.Connector;
import org.noear.solon.socketd.SessionFactory;

public class SessionFactoryManager {
    public static Map<String, SessionFactory> uriCached = new HashMap<String, SessionFactory>();
    public static Map<Class<?>, SessionFactory> clzCached = new HashMap();

    public static void register(SessionFactory factory) {
        for (String p : factory.schemes()) {
            uriCached.putIfAbsent(p, factory);
        }
        clzCached.putIfAbsent(factory.driveType(), factory);
    }

    public static Session create(Connector connector) {
        SessionFactory factory = clzCached.get(connector.driveType());
        if (factory == null) {
            throw new IllegalArgumentException("The connector is not supported");
        }
        Session session = factory.createSession(connector);
        session.setHandshaked(true);
        return session;
    }

    public static Session create(URI uri, boolean autoReconnect) {
        SessionFactory factory = uriCached.get(uri.getScheme());
        if (factory == null) {
            throw new IllegalArgumentException("The " + uri.getScheme() + " protocol is not supported");
        }
        Session session = factory.createSession(uri, autoReconnect);
        session.setHandshaked(true);
        return session;
    }
}

