/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.core.xml.util.XMLObjectSource;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AbstractXMLObjectTest
extends XMLObjectBaseTestCase {
    @Test
    public void testDOMAndXMLObjectSourceDropOnMutateContent() throws MarshallingException, IOException {
        SimpleXMLObject sxo = (SimpleXMLObject)((Object)this.buildXMLObject(simpleXMLObjectQName));
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            XMLObjectSupport.marshallToOutputStream((XMLObject)sxo, (OutputStream)baos);
            baos.flush();
            sxo.getObjectMetadata().put((Object)new XMLObjectSource(baos.toByteArray()));
        }
        Assert.assertTrue((boolean)sxo.getObjectMetadata().containsKey(XMLObjectSource.class));
        Assert.assertFalse((boolean)sxo.getObjectMetadata().get(XMLObjectSource.class).isEmpty());
        Assert.assertNotNull((Object)sxo.getDOM());
        sxo.setValue("some value");
        Assert.assertFalse((boolean)sxo.getObjectMetadata().containsKey(XMLObjectSource.class));
        Assert.assertTrue((boolean)sxo.getObjectMetadata().get(XMLObjectSource.class).isEmpty());
        Assert.assertNull((Object)sxo.getDOM());
    }

    @Test
    public void testDOMAndXMLObjectSourceDropOnMutateAttribute() throws MarshallingException, IOException {
        SimpleXMLObject sxo = (SimpleXMLObject)((Object)this.buildXMLObject(simpleXMLObjectQName));
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            XMLObjectSupport.marshallToOutputStream((XMLObject)sxo, (OutputStream)baos);
            baos.flush();
            sxo.getObjectMetadata().put((Object)new XMLObjectSource(baos.toByteArray()));
        }
        Assert.assertTrue((boolean)sxo.getObjectMetadata().containsKey(XMLObjectSource.class));
        Assert.assertFalse((boolean)sxo.getObjectMetadata().get(XMLObjectSource.class).isEmpty());
        Assert.assertNotNull((Object)sxo.getDOM());
        sxo.getUnknownAttributes().put(new QName("urn:test:ns", "foo"), "foobar");
        Assert.assertFalse((boolean)sxo.getObjectMetadata().containsKey(XMLObjectSource.class));
        Assert.assertTrue((boolean)sxo.getObjectMetadata().get(XMLObjectSource.class).isEmpty());
        Assert.assertNull((Object)sxo.getDOM());
    }

    @Test
    public void testDOMAndXMLObjectSourceDropOnMutateChildElements() throws MarshallingException, IOException {
        SimpleXMLObject sxo = (SimpleXMLObject)((Object)this.buildXMLObject(simpleXMLObjectQName));
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            XMLObjectSupport.marshallToOutputStream((XMLObject)sxo, (OutputStream)baos);
            baos.flush();
            sxo.getObjectMetadata().put((Object)new XMLObjectSource(baos.toByteArray()));
        }
        Assert.assertTrue((boolean)sxo.getObjectMetadata().containsKey(XMLObjectSource.class));
        Assert.assertFalse((boolean)sxo.getObjectMetadata().get(XMLObjectSource.class).isEmpty());
        Assert.assertNotNull((Object)sxo.getDOM());
        sxo.getUnknownXMLObjects().add((XMLObject)this.buildXMLObject(simpleXMLObjectQName));
        Assert.assertFalse((boolean)sxo.getObjectMetadata().containsKey(XMLObjectSource.class));
        Assert.assertTrue((boolean)sxo.getObjectMetadata().get(XMLObjectSource.class).isEmpty());
        Assert.assertNull((Object)sxo.getDOM());
    }
}

