/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class UnmarshallingSecurityTest
extends XMLObjectBaseTestCase {
    private BasicParserPool parserPoolDefaults;
    private BasicParserPool parserPoolInsecure;

    @BeforeClass
    public void setup() throws ComponentInitializationException {
        this.parserPoolDefaults = new BasicParserPool();
        this.parserPoolDefaults.initialize();
        this.parserPoolInsecure = new BasicParserPool();
        this.parserPoolInsecure.setIgnoreComments(false);
        this.parserPoolInsecure.setCoalescing(false);
        this.parserPoolInsecure.initialize();
    }

    @Test
    public void testUnmarshallingWithCommentInElementContentDefaults() throws XMLParserException, UnmarshallingException {
        String documentLocation = "/org/opensaml/core/xml/SimpleXMLObjectWithCommentInContent.xml";
        Document document = this.parserPoolDefaults.parse(UnmarshallingSecurityTest.class.getResourceAsStream(documentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        SimpleXMLObject sxObject = (SimpleXMLObject)unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertEquals((String)sxObject.getValue(), (String)"Content1");
    }

    @Test(expectedExceptions={UnmarshallingException.class})
    public void testUnmarshallingWithCommentInElementContentInsecure() throws XMLParserException, UnmarshallingException {
        String documentLocation = "/org/opensaml/core/xml/SimpleXMLObjectWithCommentInContent.xml";
        Document document = this.parserPoolInsecure.parse(UnmarshallingSecurityTest.class.getResourceAsStream(documentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        unmarshaller.unmarshall(document.getDocumentElement());
    }

    @Test
    public void testUnmarshallingWithCDATAInElementContentDefaults() throws XMLParserException, UnmarshallingException {
        String documentLocation = "/org/opensaml/core/xml/SimpleXMLObjectWithCDATAInContent.xml";
        Document document = this.parserPoolDefaults.parse(UnmarshallingSecurityTest.class.getResourceAsStream(documentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        SimpleXMLObject sxObject = (SimpleXMLObject)unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertEquals((String)sxObject.getValue(), (String)"Content1");
    }

    @Test(expectedExceptions={UnmarshallingException.class})
    public void testUnmarshallingWithCDATAInElementContentInsecure() throws XMLParserException, UnmarshallingException {
        String documentLocation = "/org/opensaml/core/xml/SimpleXMLObjectWithCDATAInContent.xml";
        Document document = this.parserPoolInsecure.parse(UnmarshallingSecurityTest.class.getResourceAsStream(documentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        unmarshaller.unmarshall(document.getDocumentElement());
    }

    @Test
    public void testUnmarshallingWithCommentBetweenChildElementsDefaults() throws XMLParserException, UnmarshallingException {
        String documentLocation = "/org/opensaml/core/xml/SimpleXMLObjectWithCommentBetweenChildren.xml";
        Document document = this.parserPoolDefaults.parse(UnmarshallingSecurityTest.class.getResourceAsStream(documentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        SimpleXMLObject sxObject = (SimpleXMLObject)unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertEquals((int)sxObject.getSimpleXMLObjects().size(), (int)2, (String)"Number of children elements was not expected value");
    }

    @Test(expectedExceptions={UnmarshallingException.class})
    public void testUnmarshallingWithCommentBetweenChildElementsInsecure() throws XMLParserException, UnmarshallingException {
        String documentLocation = "/org/opensaml/core/xml/SimpleXMLObjectWithCommentBetweenChildren.xml";
        Document document = this.parserPoolInsecure.parse(UnmarshallingSecurityTest.class.getResourceAsStream(documentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        unmarshaller.unmarshall(document.getDocumentElement());
    }
}

