/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml;

import java.util.List;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class UnmarshallingTest
extends XMLObjectBaseTestCase {
    @Test
    public void testUnmarshallingWithAttributes() throws XMLParserException, UnmarshallingException {
        String expectedId = "Firefly";
        String documentLocation = "/org/opensaml/core/xml/SimpleXMLObjectWithAttribute.xml";
        Document document = parserPool.parse(UnmarshallingTest.class.getResourceAsStream(documentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        SimpleXMLObject sxObject = (SimpleXMLObject)unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertNotNull((Object)sxObject.getDOM(), (String)"DOM was not cached after unmarshalling");
        Assert.assertEquals((String)sxObject.getId(), (String)expectedId, (String)"ID was not expected value");
    }

    @Test
    public void testUnmarshallingWithElementContent() throws XMLParserException, UnmarshallingException {
        String documentLocation = "/org/opensaml/core/xml/SimpleXMLObjectWithContent.xml";
        Document document = parserPool.parse(UnmarshallingTest.class.getResourceAsStream(documentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        SimpleXMLObject sxObject = (SimpleXMLObject)unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertNotNull((Object)sxObject.getDOM(), (String)"DOM was not cached after unmarshalling");
        List<SimpleXMLObject> children = sxObject.getSimpleXMLObjects();
        Assert.assertEquals((int)children.size(), (int)3, (String)"Unexpected number of children");
        SimpleXMLObject child1 = children.get(0);
        Assert.assertEquals((String)child1.getValue(), (String)"Content1", (String)"Unexpected value (text content) for child 1");
        SimpleXMLObject child2 = children.get(1);
        Assert.assertEquals((String)child2.getValue(), (String)"Content2", (String)"Unexpected value (text content) for child 2");
        SimpleXMLObject child3 = children.get(2);
        Assert.assertNull((Object)child3.getValue(), (String)"Child had text content when it should not");
        List<SimpleXMLObject> grandChildren = child3.getSimpleXMLObjects();
        Assert.assertEquals((int)grandChildren.size(), (int)1, (String)"Unexpected number of grandchildren (children for child 3)");
        SimpleXMLObject grandChild1 = grandChildren.get(0);
        Assert.assertEquals((String)grandChild1.getValue(), (String)"Content3", (String)"Unexpected value (text content) for grandchild 1");
    }

    @Test
    public void testUnmarshallingWithChildElements() throws XMLParserException, UnmarshallingException {
        String documentLocation = "/org/opensaml/core/xml/SimpleXMLObjectWithChildren.xml";
        Document document = parserPool.parse(UnmarshallingTest.class.getResourceAsStream(documentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        SimpleXMLObject sxObject = (SimpleXMLObject)unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertNotNull((Object)sxObject.getDOM(), (String)"DOM was not cached after unmarshalling");
        Assert.assertEquals((int)sxObject.getSimpleXMLObjects().size(), (int)2, (String)"Number of children elements was not expected value");
    }
}

