/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.config;

import java.io.InputStream;
import java.util.Properties;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.provider.ThreadLocalConfigurationPropertiesHolder;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLConfigurationException;
import org.opensaml.core.xml.config.XMLConfigurator;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.Unmarshaller;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ConfigurationTest {
    private BasicParserPool parserPool;
    private QName simpleXMLObjectQName;

    @Test
    public void testInvalidConfiguration() throws Exception {
        XMLConfigurator configurator = new XMLConfigurator();
        try {
            InputStream sxConfig = XMLObjectProviderRegistrySupport.class.getResourceAsStream("/org/opensaml/core/xml/config/InvalidConfiguration.xml");
            configurator.load(sxConfig);
        }
        catch (XMLConfigurationException e) {
            return;
        }
        Assert.fail((String)"Invalid configuration file passed schema validation");
    }

    @Test
    public void testObjectProviderConfiguration() throws Exception {
        XMLConfigurator configurator = new XMLConfigurator();
        InputStream sxConfig = ConfigurationTest.class.getResourceAsStream("/org/opensaml/core/xml/config/SimpleXMLObjectConfiguration.xml");
        configurator.load(sxConfig);
        XMLObjectBuilder sxBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(this.simpleXMLObjectQName);
        Assert.assertNotNull((Object)sxBuilder, (String)"SimpleXMLObject did not have a registered builder");
        Marshaller sxMarshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller(this.simpleXMLObjectQName);
        Assert.assertNotNull((Object)sxMarshaller, (String)"SimpleXMLObject did not have a registered marshaller");
        Unmarshaller sxUnmarshaller = XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(this.simpleXMLObjectQName);
        Assert.assertNotNull((Object)sxUnmarshaller, (String)"SimpleXMLObject did not have a registered unmarshaller");
        InputStream nonConfig = XMLObjectProviderRegistrySupport.class.getResourceAsStream("/org/opensaml/core/xml/config/NonexistantClassConfiguration.xml");
        try {
            configurator.load(nonConfig);
            Assert.fail((String)"Configuration loaded file that contained invalid classes");
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    @Test
    public void testIDAttributeRegistration() {
        QName attribQname = new QName("http://example.org", "someIDAttribName", "test");
        Assert.assertFalse((boolean)XMLObjectProviderRegistrySupport.isIDAttribute((QName)attribQname), (String)"Non-registered ID attribute check returned true");
        XMLObjectProviderRegistrySupport.registerIDAttribute((QName)attribQname);
        Assert.assertTrue((boolean)XMLObjectProviderRegistrySupport.isIDAttribute((QName)attribQname), (String)"Registered ID attribute check returned false");
        XMLObjectProviderRegistrySupport.deregisterIDAttribute((QName)attribQname);
        Assert.assertFalse((boolean)XMLObjectProviderRegistrySupport.isIDAttribute((QName)attribQname), (String)"Non-registered ID attribute check returned true");
        QName xmlIDQName = new QName("http://www.w3.org/XML/1998/namespace", "id");
        Assert.assertTrue((boolean)XMLObjectProviderRegistrySupport.isIDAttribute((QName)xmlIDQName), (String)"Registered ID attribute check returned false");
    }

    @Test
    public void testIDAttributeConfiguration() throws XMLParserException, XMLConfigurationException {
        XMLConfigurator configurator = new XMLConfigurator();
        QName fooQName = new QName("http://www.example.org/testObjects", "foo", "test");
        QName barQName = new QName("http://www.example.org/testObjects", "bar", "test");
        QName bazQName = new QName("http://www.example.org/testObjects", "baz", "test");
        InputStream idAttributeConfig = XMLObjectProviderRegistrySupport.class.getResourceAsStream("/org/opensaml/core/xml/config/IDAttributeConfiguration.xml");
        configurator.load(idAttributeConfig);
        Assert.assertTrue((boolean)XMLObjectProviderRegistrySupport.isIDAttribute((QName)fooQName), (String)"Registered ID attribute check returned false");
        Assert.assertTrue((boolean)XMLObjectProviderRegistrySupport.isIDAttribute((QName)barQName), (String)"Registered ID attribute check returned false");
        Assert.assertTrue((boolean)XMLObjectProviderRegistrySupport.isIDAttribute((QName)bazQName), (String)"Registered ID attribute check returned false");
        XMLObjectProviderRegistrySupport.deregisterIDAttribute((QName)fooQName);
        XMLObjectProviderRegistrySupport.deregisterIDAttribute((QName)barQName);
        XMLObjectProviderRegistrySupport.deregisterIDAttribute((QName)bazQName);
    }

    @BeforeClass
    protected void initClass() throws ComponentInitializationException {
        this.parserPool = new BasicParserPool();
        this.parserPool.setNamespaceAware(true);
        this.parserPool.initialize();
        this.simpleXMLObjectQName = new QName("http://www.example.org/testObjects", "SimpleElement");
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        Properties props = new Properties();
        props.setProperty("opensaml.config.partitionName", this.getClass().getName());
        ThreadLocalConfigurationPropertiesHolder.setProperties((Properties)props);
        ConfigurationService.register(XMLObjectProviderRegistry.class, (Object)new XMLObjectProviderRegistry());
    }

    @AfterMethod
    protected void tearDown() throws Exception {
        ConfigurationService.deregister(XMLObjectProviderRegistry.class);
        ThreadLocalConfigurationPropertiesHolder.clear();
    }
}

