/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.persist.impl;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.function.Function;
import org.opensaml.core.xml.XMLRuntimeException;
import org.opensaml.core.xml.persist.impl.PassthroughSourceStrategy;
import org.opensaml.core.xml.persist.impl.SegmentingIntermediateDirectoryStrategy;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SegmentingIntermediateDirectoryStrategyTest {
    @Test
    public void basic() {
        SegmentingIntermediateDirectoryStrategy strategy = null;
        PassthroughSourceStrategy sourceStrategy = new PassthroughSourceStrategy();
        strategy = new SegmentingIntermediateDirectoryStrategy(1, 2, (Function)sourceStrategy);
        Assert.assertEquals((Collection)strategy.apply("aabbccddeeffgg"), (Collection)Lists.newArrayList((Object[])new String[]{"aa"}));
        strategy = new SegmentingIntermediateDirectoryStrategy(3, 2, (Function)sourceStrategy);
        Assert.assertEquals((Collection)strategy.apply("aabbccddeeffgg"), (Collection)Lists.newArrayList((Object[])new String[]{"aa", "bb", "cc"}));
        strategy = new SegmentingIntermediateDirectoryStrategy(3, 4, (Function)sourceStrategy);
        Assert.assertEquals((Collection)strategy.apply("aabbccddeeffgg"), (Collection)Lists.newArrayList((Object[])new String[]{"aabb", "ccdd", "eeff"}));
    }

    @Test(expectedExceptions={XMLRuntimeException.class})
    public void sourceTooShort() {
        SegmentingIntermediateDirectoryStrategy strategy = new SegmentingIntermediateDirectoryStrategy(8, 2, (Function)new PassthroughSourceStrategy());
        strategy.apply("aabbccddeeffgg");
    }
}

