/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.schema;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.XSInteger;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class XSIntegerTest
extends XMLObjectBaseTestCase {
    private String testDocumentLocation;
    private QName expectedXMLObjectQName;
    private Integer expectedValue;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.testDocumentLocation = "/org/opensaml/core/xml/schema/xsInteger.xml";
        this.expectedXMLObjectQName = new QName("urn:example.org:foo", "bar", "foo");
        this.expectedValue = 1967;
    }

    @Test
    public void testMarshall() throws MarshallingException, XMLParserException {
        XMLObjectBuilder xsintBuilder = builderFactory.getBuilderOrThrow(XSInteger.TYPE_NAME);
        XSInteger xsInteger = (XSInteger)xsintBuilder.buildObject(this.expectedXMLObjectQName, XSInteger.TYPE_NAME);
        xsInteger.setValue(this.expectedValue);
        Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)xsInteger);
        marshaller.marshall((XMLObject)xsInteger);
        Document document = parserPool.parse(XSIntegerTest.class.getResourceAsStream(this.testDocumentLocation));
        this.assertXMLEquals("Marshalled XSInteger does not match example document", document, (XMLObject)xsInteger);
    }

    @Test
    public void testUnmarshall() throws XMLParserException, UnmarshallingException {
        Document document = parserPool.parse(XSIntegerTest.class.getResourceAsStream(this.testDocumentLocation));
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(document.getDocumentElement());
        XSInteger xsInteger = (XSInteger)unmarshaller.unmarshall(document.getDocumentElement());
        Assert.assertEquals((Object)xsInteger.getElementQName(), (Object)this.expectedXMLObjectQName, (String)"Unexpected XSInteger QName");
        Assert.assertEquals((Object)xsInteger.getSchemaType(), (Object)XSInteger.TYPE_NAME, (String)"Unexpected XSInteger schema type");
        Assert.assertEquals((Object)this.expectedValue, (Object)xsInteger.getValue(), (String)"Unexpected value of XSInteger");
    }
}

