/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.util;

import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLRuntimeException;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.core.xml.mock.SimpleXMLObjectBuilder;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLObjectSupportTest
extends XMLObjectBaseTestCase {
    @Test
    public void testXMLObjectCloneWithDropDOM() {
        SimpleXMLObjectBuilder sxoBuilder = (SimpleXMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(SimpleXMLObject.ELEMENT_NAME);
        SimpleXMLObject origChildObj = sxoBuilder.buildObject();
        origChildObj.setValue("FooBarBaz");
        SimpleXMLObject origParentObj = sxoBuilder.buildObject();
        origParentObj.getSimpleXMLObjects().add(origChildObj);
        SimpleXMLObject clonedParentObj = null;
        try {
            clonedParentObj = (SimpleXMLObject)XMLObjectSupport.cloneXMLObject((XMLObject)origParentObj, (XMLObjectSupport.CloneOutputOption)XMLObjectSupport.CloneOutputOption.DropDOM);
        }
        catch (MarshallingException e) {
            Assert.fail((String)("Object cloning failed on marshalling: " + e.getMessage()));
        }
        catch (UnmarshallingException e) {
            Assert.fail((String)("Object cloning failed on unmarshalling: " + e.getMessage()));
        }
        Assert.assertFalse((origParentObj == clonedParentObj ? 1 : 0) != 0, (String)"Parent XMLObjects were the same reference");
        Assert.assertNull((Object)clonedParentObj.getDOM(), (String)"Cloned parent DOM node was not null");
        Assert.assertFalse((boolean)clonedParentObj.getSimpleXMLObjects().isEmpty(), (String)"Cloned parent had no children");
        SimpleXMLObject clonedChildObj = clonedParentObj.getSimpleXMLObjects().get(0);
        Assert.assertFalse((origChildObj == clonedChildObj ? 1 : 0) != 0, (String)"Child XMLObjects were the same reference");
        Assert.assertNull((Object)clonedChildObj.getDOM(), (String)"Cloned child DOM node was not null");
        Assert.assertEquals((String)clonedChildObj.getValue(), (String)"FooBarBaz", (String)"Text content of child was not the expected value");
    }

    @Test
    public void testXMLObjectCloneWithUnrootedDOM() {
        SimpleXMLObjectBuilder sxoBuilder = (SimpleXMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(SimpleXMLObject.ELEMENT_NAME);
        SimpleXMLObject origChildObj = sxoBuilder.buildObject();
        origChildObj.setValue("FooBarBaz");
        SimpleXMLObject origParentObj = sxoBuilder.buildObject();
        origParentObj.getSimpleXMLObjects().add(origChildObj);
        SimpleXMLObject clonedParentObj = null;
        try {
            clonedParentObj = (SimpleXMLObject)XMLObjectSupport.cloneXMLObject((XMLObject)origParentObj, (XMLObjectSupport.CloneOutputOption)XMLObjectSupport.CloneOutputOption.UnrootedDOM);
        }
        catch (MarshallingException e) {
            Assert.fail((String)("Object cloning failed on marshalling: " + e.getMessage()));
        }
        catch (UnmarshallingException e) {
            Assert.fail((String)("Object cloning failed on unmarshalling: " + e.getMessage()));
        }
        Assert.assertFalse((origParentObj == clonedParentObj ? 1 : 0) != 0, (String)"Parent XMLObjects were the same reference");
        Assert.assertNotNull((Object)clonedParentObj.getDOM(), (String)"Cloned parent DOM node was null");
        Assert.assertFalse((boolean)origParentObj.getDOM().isSameNode(clonedParentObj.getDOM()), (String)"Parent DOM node was not cloned properly");
        Assert.assertFalse((boolean)clonedParentObj.getSimpleXMLObjects().isEmpty(), (String)"Cloned parent had no children");
        SimpleXMLObject clonedChildObj = clonedParentObj.getSimpleXMLObjects().get(0);
        Assert.assertFalse((origChildObj == clonedChildObj ? 1 : 0) != 0, (String)"Child XMLObjects were the same reference");
        Assert.assertNotNull((Object)clonedChildObj.getDOM(), (String)"Cloned child DOM node was null");
        Assert.assertFalse((boolean)origChildObj.getDOM().isSameNode(clonedChildObj.getDOM()), (String)"Child DOM node was not cloned properly");
        Assert.assertEquals((String)clonedChildObj.getValue(), (String)"FooBarBaz", (String)"Text content of child was not the expected value");
    }

    @Test
    public void testXMLObjectCloneWithRootInNewDocument() {
        SimpleXMLObjectBuilder sxoBuilder = (SimpleXMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(SimpleXMLObject.ELEMENT_NAME);
        SimpleXMLObject origChildObj = sxoBuilder.buildObject();
        origChildObj.setValue("FooBarBaz");
        SimpleXMLObject origParentObj = sxoBuilder.buildObject();
        origParentObj.getSimpleXMLObjects().add(origChildObj);
        SimpleXMLObject clonedParentObj = null;
        try {
            clonedParentObj = (SimpleXMLObject)XMLObjectSupport.cloneXMLObject((XMLObject)origParentObj, (XMLObjectSupport.CloneOutputOption)XMLObjectSupport.CloneOutputOption.RootDOMInNewDocument);
        }
        catch (MarshallingException e) {
            Assert.fail((String)("Object cloning failed on marshalling: " + e.getMessage()));
        }
        catch (UnmarshallingException e) {
            Assert.fail((String)("Object cloning failed on unmarshalling: " + e.getMessage()));
        }
        Assert.assertFalse((origParentObj == clonedParentObj ? 1 : 0) != 0, (String)"Parent XMLObjects were the same reference");
        Assert.assertNotNull((Object)clonedParentObj.getDOM(), (String)"Cloned parent DOM node was null");
        Assert.assertFalse((boolean)origParentObj.getDOM().isSameNode(clonedParentObj.getDOM()), (String)"Parent DOM node was not cloned properly");
        Assert.assertFalse((boolean)clonedParentObj.getSimpleXMLObjects().isEmpty(), (String)"Cloned parent had no children");
        SimpleXMLObject clonedChildObj = clonedParentObj.getSimpleXMLObjects().get(0);
        Assert.assertFalse((origChildObj == clonedChildObj ? 1 : 0) != 0, (String)"Child XMLObjects were the same reference");
        Assert.assertNotNull((Object)clonedChildObj.getDOM(), (String)"Cloned child DOM node was null");
        Assert.assertFalse((boolean)origChildObj.getDOM().isSameNode(clonedChildObj.getDOM()), (String)"Child DOM node was not cloned properly");
        Assert.assertEquals((String)clonedChildObj.getValue(), (String)"FooBarBaz", (String)"Text content of child was not the expected value");
        Assert.assertFalse((boolean)origParentObj.getDOM().getOwnerDocument().isSameNode(clonedParentObj.getDOM().getOwnerDocument()), (String)"Cloned objects DOM's were owned by the same Document");
        Assert.assertTrue((boolean)clonedParentObj.getDOM().getOwnerDocument().getDocumentElement().isSameNode(clonedParentObj.getDOM()), (String)"Cloned object was not the new Document root");
    }

    @Test
    public void testXMLObjectCloneInputMarshalling() throws MarshallingException, UnmarshallingException {
        SimpleXMLObjectBuilder sxoBuilder = (SimpleXMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(SimpleXMLObject.ELEMENT_NAME);
        SimpleXMLObject origChildObj = sxoBuilder.buildObject();
        origChildObj.setValue("FooBarBaz");
        SimpleXMLObject origParentObj = sxoBuilder.buildObject();
        origParentObj.getSimpleXMLObjects().add(origChildObj);
        Assert.assertNull((Object)origParentObj.getDOM());
        SimpleXMLObject clonedParentObj = (SimpleXMLObject)XMLObjectSupport.cloneXMLObject((XMLObject)origParentObj, (XMLObjectSupport.CloneOutputOption)XMLObjectSupport.CloneOutputOption.DropDOM);
        Assert.assertNotNull((Object)((Object)clonedParentObj));
        Assert.assertNotNull((Object)origParentObj.getDOM());
        Element preCloneElement = origParentObj.getDOM();
        Document preCloneDocument = origParentObj.getDOM().getOwnerDocument();
        clonedParentObj = (SimpleXMLObject)XMLObjectSupport.cloneXMLObject((XMLObject)origParentObj, (XMLObjectSupport.CloneOutputOption)XMLObjectSupport.CloneOutputOption.DropDOM);
        Assert.assertNotNull((Object)((Object)clonedParentObj));
        Assert.assertNotNull((Object)origParentObj.getDOM());
        Assert.assertTrue((boolean)preCloneElement.isSameNode(origParentObj.getDOM()));
        Assert.assertTrue((boolean)preCloneDocument.isSameNode(origParentObj.getDOM().getOwnerDocument()));
    }

    @Test
    public void testBuildXMLObject() {
        try {
            XMLObjectSupport.buildXMLObject((QName)simpleXMLObjectQName);
        }
        catch (Exception e) {
            Assert.fail((String)"Expected XMLObject could not be built");
        }
        try {
            XMLObjectSupport.buildXMLObject((QName)simpleXMLObjectQName, (QName)XSString.TYPE_NAME);
        }
        catch (Exception e) {
            Assert.fail((String)"Expected XMLObject could not be built");
        }
        try {
            XMLObjectSupport.buildXMLObject((QName)new QName("urn:test:bogus", "foo"));
            Assert.fail((String)"buildXMLObject did not throw as expected");
        }
        catch (XMLRuntimeException xMLRuntimeException) {
            // empty catch block
        }
        try {
            XMLObjectSupport.buildXMLObject((QName)new QName("urn:test:bogus", "foo"), (QName)XSString.TYPE_NAME);
            Assert.fail((String)"buildXMLObject did not throw as expected");
        }
        catch (XMLRuntimeException xMLRuntimeException) {
            // empty catch block
        }
    }
}

