/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.context;

import java.util.Iterator;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.testing.TestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class BaseContextTest {
    public void testNoArgConstructor() {
        TestContext context = new TestContext();
        Assert.assertNull((Object)context.getParent());
    }

    public void testAddRemoveSubcontexts() {
        TestContext parent = new TestContext();
        TestContext child = new TestContext();
        Assert.assertNull((Object)parent.getParent());
        Assert.assertNull((Object)child.getParent());
        parent.addSubcontext(child);
        Assert.assertNull((Object)parent.getParent());
        Assert.assertNotNull((Object)child.getParent());
        Assert.assertTrue((child.getParent() == parent ? 1 : 0) != 0, (String)"Parent of child is not the expected value");
        Assert.assertTrue((parent.getSubcontext(TestContext.class, false) == child ? 1 : 0) != 0, (String)"Child of parent is not the expected value");
        parent.removeSubcontext(TestContext.class);
        Assert.assertNull((Object)parent.getParent());
        Assert.assertNull((Object)child.getParent());
        parent.addSubcontext(child);
        Assert.assertNull((Object)parent.getParent());
        Assert.assertNotNull((Object)child.getParent());
        Assert.assertTrue((child.getParent() == parent ? 1 : 0) != 0, (String)"Parent of child is not the expected value");
        Assert.assertTrue((parent.getSubcontext(TestContext.class, false) == child ? 1 : 0) != 0, (String)"Child of parent is not the expected value");
        parent.removeSubcontext(child);
        Assert.assertNull((Object)parent.getParent());
        Assert.assertNull((Object)child.getParent());
    }

    public void testClearSubcontexts() {
        TestContext parent = new TestContext();
        TestContext child = new TestContext();
        Assert.assertNull((Object)parent.getParent());
        Assert.assertNull((Object)child.getParent());
        parent.addSubcontext(child);
        Assert.assertNull((Object)parent.getParent());
        Assert.assertNotNull((Object)child.getParent());
        Assert.assertTrue((child.getParent() == parent ? 1 : 0) != 0, (String)"Parent of child is not the expected value");
        Assert.assertTrue((parent.getSubcontext(TestContext.class, false) == child ? 1 : 0) != 0, (String)"Child of parent is not the expected value");
        parent.clearSubcontexts();
        Assert.assertNull((Object)parent.getParent());
        Assert.assertNull((Object)child.getParent());
    }

    public void testBasicIteration() {
        TestContext parent = new TestContext();
        TestContext child = new TestContext();
        Assert.assertNull((Object)child.getParent());
        parent.addSubcontext(child);
        Assert.assertTrue((child.getParent() == parent ? 1 : 0) != 0, (String)"Parent of child is not the expected value");
        Assert.assertTrue((parent.getSubcontext(TestContext.class, false) == child ? 1 : 0) != 0, (String)"Child of parent is not the expected value");
        Iterator iterator = parent.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        BaseContext returnedContext = (BaseContext)iterator.next();
        Assert.assertTrue((returnedContext == child ? 1 : 0) != 0);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testNoRemoveIterator() {
        TestContext parent = new TestContext();
        Iterator iterator = parent.iterator();
        iterator.remove();
    }

    public void testDuplicateAddWithReplace() {
        TestContext parent = new TestContext();
        Assert.assertFalse((boolean)parent.containsSubcontext(TestContext.class));
        TestContext child1 = new TestContext();
        parent.addSubcontext(child1);
        Assert.assertTrue((boolean)parent.containsSubcontext(TestContext.class));
        Assert.assertTrue((parent.getSubcontext(TestContext.class, false) == child1 ? 1 : 0) != 0);
        Assert.assertTrue((child1.getParent() == parent ? 1 : 0) != 0);
        TestContext child2 = new TestContext();
        parent.addSubcontext(child2, true);
        Assert.assertTrue((boolean)parent.containsSubcontext(TestContext.class));
        Assert.assertTrue((parent.getSubcontext(TestContext.class, false) == child2 ? 1 : 0) != 0);
        Assert.assertTrue((child2.getParent() == parent ? 1 : 0) != 0);
        Assert.assertNull((Object)child1.getParent());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDuplicateAddWithoutReplace() {
        TestContext parent = new TestContext();
        Assert.assertFalse((boolean)parent.containsSubcontext(TestContext.class));
        TestContext child1 = new TestContext();
        parent.addSubcontext(child1);
        Assert.assertTrue((boolean)parent.containsSubcontext(TestContext.class));
        Assert.assertTrue((parent.getSubcontext(TestContext.class, false) == child1 ? 1 : 0) != 0);
        Assert.assertTrue((child1.getParent() == parent ? 1 : 0) != 0);
        TestContext child2 = new TestContext();
        parent.addSubcontext(child2, false);
    }

    public void testAddWith2Parents() {
        TestContext parent1 = new TestContext();
        Assert.assertFalse((boolean)parent1.containsSubcontext(TestContext.class));
        TestContext child = new TestContext();
        parent1.addSubcontext(child);
        Assert.assertTrue((boolean)parent1.containsSubcontext(TestContext.class));
        Assert.assertTrue((parent1.getSubcontext(TestContext.class, false) == child ? 1 : 0) != 0);
        Assert.assertTrue((child.getParent() == parent1 ? 1 : 0) != 0);
        TestContext parent2 = new TestContext();
        Assert.assertFalse((boolean)parent2.containsSubcontext(TestContext.class));
        parent2.addSubcontext(child);
        Assert.assertTrue((boolean)parent2.containsSubcontext(TestContext.class));
        Assert.assertTrue((parent2.getSubcontext(TestContext.class, false) == child ? 1 : 0) != 0);
        Assert.assertTrue((child.getParent() == parent2 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)parent1.containsSubcontext(TestContext.class));
        Assert.assertNull((Object)parent1.getSubcontext(TestContext.class, false));
    }

    public void testStringAccess() throws ClassNotFoundException {
        TestContext parent = new TestContext();
        parent.addSubcontext(new TestContext());
        BaseContext child = parent.getSubcontext("org.opensaml.messaging.context.testing.TestContext");
        Assert.assertNotNull((Object)child);
        Assert.assertTrue((boolean)(child instanceof TestContext));
    }

    public void testStringAccessMissing() throws ClassNotFoundException {
        TestContext parent = new TestContext();
        parent.addSubcontext(new TestContext());
        BaseContext child = parent.getSubcontext("org.opensaml.messaging.context.MessageContext");
        Assert.assertNull((Object)child);
    }

    public void testSimpleStringAccess() throws ClassNotFoundException {
        TestContext parent = new TestContext();
        parent.addSubcontext(new TestContext());
        BaseContext child = parent.getSubcontext("TestContext");
        Assert.assertNotNull((Object)child);
        Assert.assertTrue((boolean)(child instanceof TestContext));
    }

    @Test(expectedExceptions={ClassNotFoundException.class})
    public void testSimpleStringError() throws ClassNotFoundException {
        TestContext parent = new TestContext();
        parent.addSubcontext(new TestContext());
        parent.getSubcontext("NoContext");
    }
}

