/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.messaging.handler.impl.CheckExpectedIssuer;
import org.testng.annotations.Test;

public class CheckExpectedIssuerTest {
    @Test
    public void testMatch() throws Exception {
        CheckExpectedIssuer action = new CheckExpectedIssuer();
        action.setIssuerLookupStrategy(FunctionSupport.constant((Object)"issuer"));
        action.setExpectedIssuerLookupStrategy(FunctionSupport.constant((Object)"issuer"));
        action.initialize();
        MessageContext mc = new MessageContext();
        action.invoke(mc);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testNotMatch() throws Exception {
        CheckExpectedIssuer action = new CheckExpectedIssuer();
        action.setIssuerLookupStrategy(FunctionSupport.constant((Object)"issuer"));
        action.setExpectedIssuerLookupStrategy(FunctionSupport.constant((Object)"issuerNOT"));
        action.initialize();
        MessageContext mc = new MessageContext();
        action.invoke(mc);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testNoIssuer() throws Exception {
        CheckExpectedIssuer action = new CheckExpectedIssuer();
        action.setIssuerLookupStrategy(FunctionSupport.constant(null));
        action.setExpectedIssuerLookupStrategy(FunctionSupport.constant((Object)"issuer"));
        action.initialize();
        MessageContext mc = new MessageContext();
        action.invoke(mc);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testNoExpectedIssuer() throws Exception {
        CheckExpectedIssuer action = new CheckExpectedIssuer();
        action.setIssuerLookupStrategy(FunctionSupport.constant((Object)"issuer"));
        action.setExpectedIssuerLookupStrategy(FunctionSupport.constant((Object)"null"));
        action.initialize();
        MessageContext mc = new MessageContext();
        action.invoke(mc);
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testMissingIssuerStrategy() throws Exception {
        CheckExpectedIssuer action = new CheckExpectedIssuer();
        action.setExpectedIssuerLookupStrategy(FunctionSupport.constant((Object)"issuer"));
        action.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testMissingExpectedIssuerStrategy() throws Exception {
        CheckExpectedIssuer action = new CheckExpectedIssuer();
        action.setIssuerLookupStrategy(FunctionSupport.constant((Object)"issuer"));
        action.initialize();
    }
}

