/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import javax.servlet.http.HttpServletRequest;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.messaging.handler.impl.HTTPRequestValidationHandler;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HTTPRequestValidationHandlerTest {
    private MockHttpServletRequest httpRequest;
    private String contentType = "text/html";
    private String method = "POST";
    private boolean requireSecured = true;
    private HTTPRequestValidationHandler handler;
    private MessageContext messageContext;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.httpRequest = this.buildServletRequest();
        this.messageContext = new MessageContext();
        this.handler = new HTTPRequestValidationHandler();
        this.handler.setHttpServletRequest((HttpServletRequest)this.httpRequest);
        this.handler.setRequiredRequestMethod(this.method);
        this.handler.setRequiredContentType(this.contentType);
        this.handler.setRequireSecured(true);
        this.handler.initialize();
    }

    protected MockHttpServletRequest buildServletRequest() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContentType(this.contentType);
        request.setMethod(this.method);
        request.setSecure(this.requireSecured);
        return request;
    }

    @Test
    public void testAllGood() throws MessageHandlerException {
        this.handler.invoke(this.messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testContentTypeBad() throws MessageHandlerException {
        this.httpRequest.setContentType("GARBAGE");
        this.handler.invoke(this.messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testRequestMethodBad() throws MessageHandlerException {
        this.httpRequest.setMethod("GARBAGE");
        this.handler.invoke(this.messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testRequireSecureBad() throws MessageHandlerException {
        this.httpRequest.setSecure(!this.requireSecured);
        this.handler.invoke(this.messageContext);
    }
}

