/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import java.io.InputStream;
import javax.xml.validation.Schema;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.SchemaBuilder;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.core.xml.mock.SimpleXMLObjectBuilder;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.messaging.handler.impl.SchemaValidateXMLMessage;
import org.springframework.core.io.ClassPathResource;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SchemaValidateXMLMessageTest
extends XMLObjectBaseTestCase {
    private static final String SCHEMA_FILE = "org/opensaml/messaging/handler/impl/schemaValidateXmlMessageTest-schema.xsd";
    private static final String INVALID_XML_FILE = "org/opensaml/messaging/handler/impl/schemaValidateXmlMessageTest-invalid.xml";
    private static final String VALID_XML_FILE = "org/opensaml/messaging/handler/impl/schemaValidateXmlMessageTest-valid.xml";
    private Schema schema;

    @BeforeClass
    public void setUp() throws Exception {
        ClassPathResource r = new ClassPathResource(SCHEMA_FILE);
        SchemaBuilder schemaBuilder = new SchemaBuilder();
        schemaBuilder.addSchema(r.getInputStream());
        this.schema = schemaBuilder.buildSchema();
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testNullInboundMessageContext() throws Exception {
        SchemaValidateXMLMessage handler = new SchemaValidateXMLMessage(this.schema);
        handler.initialize();
        MessageContext messageContext = new MessageContext();
        handler.invoke(messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testNullDom() throws Exception {
        SchemaValidateXMLMessage handler = new SchemaValidateXMLMessage(this.schema);
        handler.initialize();
        MessageContext messageContext = new MessageContext();
        SimpleXMLObject simpleXml = new SimpleXMLObjectBuilder().buildObject();
        messageContext.setMessage((Object)simpleXml);
        handler.invoke(messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testInvalidSchema() throws Exception {
        SchemaValidateXMLMessage handler = new SchemaValidateXMLMessage(this.schema);
        handler.initialize();
        MessageContext messageContext = new MessageContext();
        ClassPathResource invalidXmlResource = new ClassPathResource(INVALID_XML_FILE);
        XMLObject invalidXml = XMLObjectSupport.unmarshallFromInputStream((ParserPool)parserPool, (InputStream)invalidXmlResource.getInputStream());
        messageContext.setMessage((Object)invalidXml);
        handler.invoke(messageContext);
    }

    @Test
    public void testValidSchema() throws Exception {
        SchemaValidateXMLMessage handler = new SchemaValidateXMLMessage(this.schema);
        handler.initialize();
        MessageContext messageContext = new MessageContext();
        ClassPathResource validXmlResource = new ClassPathResource(VALID_XML_FILE);
        XMLObject validXml = XMLObjectSupport.unmarshallFromInputStream((ParserPool)parserPool, (InputStream)validXmlResource.getInputStream());
        messageContext.setMessage((Object)validXml);
        handler.invoke(messageContext);
    }
}

