/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.messaging.context.MessageChannelSecurityContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.messaging.handler.impl.URLEvaluatingMessageChannelSecurity;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class URLEvaluatingMessageChannelSecurityTest {
    private URLEvaluatingMessageChannelSecurity handler;
    private MessageContext messageContext;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.handler = new URLEvaluatingMessageChannelSecurity();
        this.messageContext = new MessageContext();
    }

    @Test
    public void testHTTPSNoPort() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setURLLookup(FunctionSupport.constant((Object)"https://www.example.edu"));
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        MessageChannelSecurityContext channelSecurityContext = (MessageChannelSecurityContext)this.messageContext.getSubcontext(MessageChannelSecurityContext.class);
        Assert.assertNotNull((Object)channelSecurityContext);
        Assert.assertFalse((boolean)channelSecurityContext.isIntegrityActive());
        Assert.assertFalse((boolean)channelSecurityContext.isConfidentialityActive());
    }

    @Test
    public void testHTTPSWithDefaultPort() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setURLLookup(FunctionSupport.constant((Object)"https://www.example.edu:443"));
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        MessageChannelSecurityContext channelSecurityContext = (MessageChannelSecurityContext)this.messageContext.getSubcontext(MessageChannelSecurityContext.class);
        Assert.assertNotNull((Object)channelSecurityContext);
        Assert.assertFalse((boolean)channelSecurityContext.isIntegrityActive());
        Assert.assertFalse((boolean)channelSecurityContext.isConfidentialityActive());
    }

    @Test
    public void testHTTPSWithDefaultPortAsSecure() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setURLLookup(FunctionSupport.constant((Object)"https://www.example.edu:443"));
        this.handler.setDefaultPortInsecure(false);
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        MessageChannelSecurityContext channelSecurityContext = (MessageChannelSecurityContext)this.messageContext.getSubcontext(MessageChannelSecurityContext.class);
        Assert.assertNotNull((Object)channelSecurityContext);
        Assert.assertTrue((boolean)channelSecurityContext.isIntegrityActive());
        Assert.assertTrue((boolean)channelSecurityContext.isConfidentialityActive());
    }

    @Test
    public void testHTTPSNoPortAsSecure() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setURLLookup(FunctionSupport.constant((Object)"https://www.example.edu"));
        this.handler.setDefaultPortInsecure(false);
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        MessageChannelSecurityContext channelSecurityContext = (MessageChannelSecurityContext)this.messageContext.getSubcontext(MessageChannelSecurityContext.class);
        Assert.assertNotNull((Object)channelSecurityContext);
        Assert.assertTrue((boolean)channelSecurityContext.isIntegrityActive());
        Assert.assertTrue((boolean)channelSecurityContext.isConfidentialityActive());
    }

    @Test
    public void testHTTPSWithNonDefaultPort() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setURLLookup(FunctionSupport.constant((Object)"https://www.example.edu:8443"));
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        MessageChannelSecurityContext channelSecurityContext = (MessageChannelSecurityContext)this.messageContext.getSubcontext(MessageChannelSecurityContext.class);
        Assert.assertNotNull((Object)channelSecurityContext);
        Assert.assertTrue((boolean)channelSecurityContext.isIntegrityActive());
        Assert.assertTrue((boolean)channelSecurityContext.isConfidentialityActive());
    }

    @Test
    public void testHTTPNoPort() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setURLLookup(FunctionSupport.constant((Object)"http://www.example.edu"));
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        MessageChannelSecurityContext channelSecurityContext = (MessageChannelSecurityContext)this.messageContext.getSubcontext(MessageChannelSecurityContext.class);
        Assert.assertNotNull((Object)channelSecurityContext);
        Assert.assertFalse((boolean)channelSecurityContext.isIntegrityActive());
        Assert.assertFalse((boolean)channelSecurityContext.isConfidentialityActive());
    }

    @Test
    public void testHTTPWithPort() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setURLLookup(FunctionSupport.constant((Object)"http://www.example.edu:80"));
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        MessageChannelSecurityContext channelSecurityContext = (MessageChannelSecurityContext)this.messageContext.getSubcontext(MessageChannelSecurityContext.class);
        Assert.assertNotNull((Object)channelSecurityContext);
        Assert.assertFalse((boolean)channelSecurityContext.isIntegrityActive());
        Assert.assertFalse((boolean)channelSecurityContext.isConfidentialityActive());
    }

    @Test
    public void testBadURL() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setURLLookup(FunctionSupport.constant((Object)"foobar"));
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        MessageChannelSecurityContext channelSecurityContext = (MessageChannelSecurityContext)this.messageContext.getSubcontext(MessageChannelSecurityContext.class);
        Assert.assertNull((Object)channelSecurityContext);
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testMissingURLLookup() throws ComponentInitializationException {
        this.handler.initialize();
    }
}

