/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.logic;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.ext.spring.config.IdentifiableBeanPostProcessor;
import net.shibboleth.ext.spring.util.ApplicationContextBuilder;
import org.opensaml.profile.logic.IPRangePredicate;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IPRangePredicateTest {
    @Test
    public void testRanges() {
        GenericApplicationContext ctx = new ApplicationContextBuilder().setName("IpRange").setServiceConfiguration((Resource)new ClassPathResource("iprange.xml")).setBeanPostProcessor((BeanPostProcessor)new IdentifiableBeanPostProcessor()).build();
        Map map = ctx.getBeansOfType(IPRangePredicate.class);
        Assert.assertEquals((int)map.size(), (int)2);
        MockHttpServletRequest request = new MockHttpServletRequest();
        IPRangePredicate condition = (IPRangePredicate)map.get("three");
        condition.setHttpServletRequest((HttpServletRequest)request);
        request.setRemoteAddr("192.168.1.128");
        Assert.assertTrue((boolean)condition.test(null));
        request.setRemoteAddr("192.168.3.128");
        Assert.assertFalse((boolean)condition.test(null));
        request.setRemoteAddr("::1");
        Assert.assertFalse((boolean)condition.test(null));
        condition = (IPRangePredicate)map.get("four");
        condition.setHttpServletRequest((HttpServletRequest)request);
        request.setRemoteAddr("2620:df:8000:ff14:0:0:0:2");
        Assert.assertTrue((boolean)condition.test(null));
        request.setRemoteAddr("2620:df:8000:ff14:0:0:0:3");
        Assert.assertFalse((boolean)condition.test(null));
        request.setRemoteAddr("[2620:df:8000:ff14:0:0:0:2]");
        Assert.assertTrue((boolean)condition.test(null));
    }
}

