/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.AbstractMessageDecoder;
import org.opensaml.messaging.decoder.MessageDecoder;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.profile.action.impl.DecodeMessage;
import org.opensaml.profile.action.impl.MockMessage;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DecodeMessageTest {
    private MockMessage message;
    private MockMessageDecoder decoder;
    private ProfileRequestContext profileCtx;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.message = new MockMessage();
        this.decoder = new MockMessageDecoder(this.message);
        this.decoder.initialize();
        this.profileCtx = new ProfileRequestContext();
    }

    @Test
    public void testDecodeMessage() throws ComponentInitializationException {
        DecodeMessage action = new DecodeMessage((MessageDecoder)this.decoder);
        action.initialize();
        action.execute(this.profileCtx);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.profileCtx);
        Assert.assertNotNull((Object)this.profileCtx.getInboundMessageContext());
        Assert.assertEquals((Object)this.profileCtx.getInboundMessageContext().getMessage(), (Object)this.message);
    }

    @Test
    public void testFailure() throws ComponentInitializationException {
        this.decoder.setThrowException(true);
        DecodeMessage action = new DecodeMessage((MessageDecoder)this.decoder);
        action.initialize();
        action.execute(this.profileCtx);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.profileCtx, (Object)"UnableToDecode");
    }

    class MockMessageDecoder
    extends AbstractMessageDecoder {
        private boolean throwException = false;
        private MockMessage message;

        public MockMessageDecoder(MockMessage mockMessage) {
            this.message = mockMessage;
        }

        public void setThrowException(boolean shouldThrowDecodeException) {
            this.throwException = shouldThrowDecodeException;
        }

        protected void doDecode() throws MessageDecodingException {
            if (this.throwException) {
                throw new MessageDecodingException();
            }
            MessageContext messageContext = new MessageContext();
            if (this.message != null) {
                messageContext.setMessage((Object)this.message);
            } else {
                messageContext.setMessage((Object)new MockMessage());
            }
            this.setMessageContext(messageContext);
        }
    }
}

