/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.AbstractMessageEncoder;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.profile.action.impl.EncodeMessage;
import org.opensaml.profile.action.impl.MockMessage;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EncodeMessageTest {
    private MockMessage message;
    private MockMessageEncoder encoder;
    private MessageContext messageContext;
    private ProfileRequestContext profileCtx;
    private String expectedMessage;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.message = new MockMessage();
        this.message.getProperties().put("foo", "3");
        this.message.getProperties().put("bar", "1");
        this.message.getProperties().put("baz", "2");
        this.expectedMessage = "bar=1&baz=2&foo=3";
        this.messageContext = new MessageContext();
        this.messageContext.setMessage((Object)this.message);
        this.profileCtx = new ProfileRequestContext();
        this.profileCtx.setOutboundMessageContext(this.messageContext);
        this.encoder = new MockMessageEncoder();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoFactory() throws ComponentInitializationException {
        EncodeMessage action = new EncodeMessage();
        action.initialize();
    }

    @Test
    public void testDecodeMessage() throws Exception {
        EncodeMessage action = new EncodeMessage();
        action.setMessageEncoderFactory((Function)new MockEncoderFactory());
        action.initialize();
        action.execute(this.profileCtx);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.profileCtx);
        Assert.assertEquals((String)this.encoder.getEncodedMessage(), (String)this.expectedMessage);
    }

    @Test
    public void testThrowException() throws Exception {
        this.encoder.setThrowException(true);
        EncodeMessage action = new EncodeMessage();
        action.setMessageEncoderFactory((Function)new MockEncoderFactory());
        action.initialize();
        action.execute(this.profileCtx);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.profileCtx, (Object)"UnableToEncode");
    }

    private class MockMessageEncoder
    extends AbstractMessageEncoder {
        private boolean throwException = false;
        private String message;

        private MockMessageEncoder() {
        }

        public String getEncodedMessage() {
            return this.message;
        }

        public void setThrowException(boolean shouldThrowDecodeException) {
            this.throwException = shouldThrowDecodeException;
        }

        protected void doEncode() throws MessageEncodingException {
            if (this.throwException) {
                throw new MessageEncodingException();
            }
            this.message = ((MockMessage)this.getMessageContext().getMessage()).getEncoded();
        }
    }

    private class MockEncoderFactory
    implements Function<ProfileRequestContext, MessageEncoder> {
        private MockEncoderFactory() {
        }

        @Override
        @Nullable
        public MessageEncoder apply(@Nonnull ProfileRequestContext profileRequestContext) {
            return EncodeMessageTest.this.encoder;
        }
    }
}

