/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import java.util.Collections;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.action.impl.PopulateClientTLSValidationParameters;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.security.messaging.ClientTLSSecurityParametersContext;
import org.opensaml.security.x509.tls.ClientTLSValidationConfigurationCriterion;
import org.opensaml.security.x509.tls.ClientTLSValidationParameters;
import org.opensaml.security.x509.tls.ClientTLSValidationParametersResolver;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateClientTLSValidationParametersTest
extends OpenSAMLInitBaseTestCase {
    private ProfileRequestContext prc;
    private PopulateClientTLSValidationParameters action;

    @BeforeMethod
    public void setUp() {
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action = new PopulateClientTLSValidationParameters();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testConfig() throws ComponentInitializationException {
        this.action.initialize();
    }

    @Test
    public void testNoContext() throws Exception {
        this.action.setClientTLSValidationParametersResolver((ClientTLSValidationParametersResolver)new MockResolver(false));
        this.action.initialize();
        this.prc.setInboundMessageContext(null);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidProfileContext");
    }

    @Test
    public void testResolverError() throws Exception {
        this.action.setClientTLSValidationParametersResolver((ClientTLSValidationParametersResolver)new MockResolver(true));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidSecurityConfiguration");
    }

    @Test
    public void testSuccess() throws Exception {
        this.action.setClientTLSValidationParametersResolver((ClientTLSValidationParametersResolver)new MockResolver(false));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNotNull((Object)((ClientTLSSecurityParametersContext)this.prc.getInboundMessageContext().getSubcontext(ClientTLSSecurityParametersContext.class)).getValidationParameters());
    }

    private class MockResolver
    implements ClientTLSValidationParametersResolver {
        private boolean throwException;

        public MockResolver(boolean shouldThrow) {
            this.throwException = shouldThrow;
        }

        public Iterable<ClientTLSValidationParameters> resolve(CriteriaSet criteria) throws ResolverException {
            return Collections.singletonList(this.resolveSingle(criteria));
        }

        public ClientTLSValidationParameters resolveSingle(CriteriaSet criteria) throws ResolverException {
            if (this.throwException) {
                throw new ResolverException();
            }
            Constraint.isNotNull((Object)((ClientTLSValidationConfigurationCriterion)criteria.get(ClientTLSValidationConfigurationCriterion.class)), (String)"Criterion was null");
            return new ClientTLSValidationParameters();
        }
    }
}

