/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import java.util.Collections;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.action.impl.PopulateDecryptionParameters;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.xmlsec.DecryptionParameters;
import org.opensaml.xmlsec.DecryptionParametersResolver;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.criterion.DecryptionConfigurationCriterion;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateDecryptionParametersTest
extends OpenSAMLInitBaseTestCase {
    private ProfileRequestContext prc;
    private PopulateDecryptionParameters action;

    @BeforeMethod
    public void setUp() {
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action = new PopulateDecryptionParameters();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testConfig() throws ComponentInitializationException {
        this.action.initialize();
    }

    @Test
    public void testNoContext() throws Exception {
        this.action.setDecryptionParametersResolver((DecryptionParametersResolver)new MockResolver(false));
        this.action.initialize();
        this.prc.setInboundMessageContext(null);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidProfileContext");
    }

    @Test
    public void testResolverError() throws Exception {
        this.action.setDecryptionParametersResolver((DecryptionParametersResolver)new MockResolver(true));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidSecurityConfiguration");
    }

    @Test
    public void testSuccess() throws Exception {
        this.action.setDecryptionParametersResolver((DecryptionParametersResolver)new MockResolver(false));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNotNull((Object)((SecurityParametersContext)this.prc.getInboundMessageContext().getSubcontext(SecurityParametersContext.class)).getDecryptionParameters());
    }

    private class MockResolver
    implements DecryptionParametersResolver {
        private boolean throwException;

        public MockResolver(boolean shouldThrow) {
            this.throwException = shouldThrow;
        }

        public Iterable<DecryptionParameters> resolve(CriteriaSet criteria) throws ResolverException {
            return Collections.singletonList(this.resolveSingle(criteria));
        }

        public DecryptionParameters resolveSingle(CriteriaSet criteria) throws ResolverException {
            if (this.throwException) {
                throw new ResolverException();
            }
            Constraint.isNotNull((Object)((DecryptionConfigurationCriterion)criteria.get(DecryptionConfigurationCriterion.class)), (String)"Criterion was null");
            return new DecryptionParameters();
        }
    }
}

