/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import java.util.Collections;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.action.impl.PopulateSignatureValidationParameters;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.SignatureValidationParametersResolver;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.criterion.SignatureValidationConfigurationCriterion;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateSignatureValidationParametersTest
extends OpenSAMLInitBaseTestCase {
    private ProfileRequestContext prc;
    private PopulateSignatureValidationParameters action;

    @BeforeMethod
    public void setUp() {
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action = new PopulateSignatureValidationParameters();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testConfig() throws ComponentInitializationException {
        this.action.initialize();
    }

    @Test
    public void testNoContext() throws Exception {
        this.action.setSignatureValidationParametersResolver((SignatureValidationParametersResolver)new MockResolver(false));
        this.action.initialize();
        this.prc.setInboundMessageContext(null);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testResolverError() throws Exception {
        this.action.setSignatureValidationParametersResolver((SignatureValidationParametersResolver)new MockResolver(true));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"MessageProcessingError");
    }

    @Test
    public void testSuccess() throws Exception {
        this.action.setSignatureValidationParametersResolver((SignatureValidationParametersResolver)new MockResolver(false));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNotNull((Object)((SecurityParametersContext)this.prc.getInboundMessageContext().getSubcontext(SecurityParametersContext.class)).getSignatureValidationParameters());
    }

    private class MockResolver
    implements SignatureValidationParametersResolver {
        private boolean throwException;

        public MockResolver(boolean shouldThrow) {
            this.throwException = shouldThrow;
        }

        public Iterable<SignatureValidationParameters> resolve(CriteriaSet criteria) throws ResolverException {
            return Collections.singletonList(this.resolveSingle(criteria));
        }

        public SignatureValidationParameters resolveSingle(CriteriaSet criteria) throws ResolverException {
            if (this.throwException) {
                throw new ResolverException();
            }
            Constraint.isNotNull((Object)((SignatureValidationConfigurationCriterion)criteria.get(SignatureValidationConfigurationCriterion.class)), (String)"Criterion was null");
            return new SignatureValidationParameters();
        }
    }
}

