/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.impl;

import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.binding.impl.SAMLOutboundDestinationHandler;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SAMLOutboundDestinationHandlerTest
extends XMLObjectBaseTestCase {
    private SAMLOutboundDestinationHandler handler;
    private MessageContext messageContext;

    @BeforeMethod
    public void setUp() {
        SAMLObjectBuilder endpointBuilder = (SAMLObjectBuilder)builderFactory.getBuilderOrThrow(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        AssertionConsumerService samlEndpoint = (AssertionConsumerService)endpointBuilder.buildObject();
        samlEndpoint.setLocation("http://example.org");
        this.handler = new SAMLOutboundDestinationHandler();
        this.messageContext = new MessageContext();
        ((SAMLEndpointContext)((SAMLPeerEntityContext)this.messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLEndpointContext.class, true)).setEndpoint((Endpoint)samlEndpoint);
    }

    @Test
    public void testSAML1Response() throws MessageHandlerException {
        SAMLObjectBuilder requestBuilder = (SAMLObjectBuilder)builderFactory.getBuilderOrThrow(Response.DEFAULT_ELEMENT_NAME);
        Response samlMessage = (Response)requestBuilder.buildObject();
        this.messageContext.setMessage((Object)samlMessage);
        Assert.assertNull((Object)samlMessage.getRecipient(), (String)"Recipient was not null");
        this.handler.invoke(this.messageContext);
        Assert.assertNotNull((Object)samlMessage.getRecipient(), (String)"Recipient was null");
    }

    @Test
    public void testSAML2Request() throws MessageHandlerException {
        SAMLObjectBuilder requestBuilder = (SAMLObjectBuilder)builderFactory.getBuilderOrThrow(AuthnRequest.DEFAULT_ELEMENT_NAME);
        AuthnRequest samlMessage = (AuthnRequest)requestBuilder.buildObject();
        this.messageContext.setMessage((Object)samlMessage);
        Assert.assertNull((Object)samlMessage.getDestination(), (String)"Destination was not null");
        this.handler.invoke(this.messageContext);
        Assert.assertNotNull((Object)samlMessage.getDestination(), (String)"Destination was null");
    }

    @Test
    public void testSAML2Response() throws MessageHandlerException {
        SAMLObjectBuilder requestBuilder = (SAMLObjectBuilder)builderFactory.getBuilderOrThrow(org.opensaml.saml.saml2.core.Response.DEFAULT_ELEMENT_NAME);
        org.opensaml.saml.saml2.core.Response samlMessage = (org.opensaml.saml.saml2.core.Response)requestBuilder.buildObject();
        this.messageContext.setMessage((Object)samlMessage);
        Assert.assertNull((Object)samlMessage.getDestination(), (String)"Destination was not null");
        this.handler.invoke(this.messageContext);
        Assert.assertNotNull((Object)samlMessage.getDestination(), (String)"Destination was null");
    }
}

