/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.binding.security.impl.InResponseToSecurityHandler;
import org.opensaml.saml.saml1.core.Request;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml2.core.ArtifactResolve;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class InResponseToSecurityHandlerTest
extends XMLObjectBaseTestCase {
    private InOutOperationContext opContext;
    private InResponseToSecurityHandler handler;

    @BeforeClass
    public void setup() throws ComponentInitializationException {
        this.handler = new InResponseToSecurityHandler();
        this.handler.initialize();
        this.opContext = new InOutOperationContext(new MessageContext(), new MessageContext());
    }

    @Test
    public void testSAML2Match() throws MessageHandlerException {
        ArtifactResolve request = (ArtifactResolve)this.buildXMLObject(ArtifactResolve.DEFAULT_ELEMENT_NAME);
        request.setID("abc123");
        this.opContext.getOutboundMessageContext().setMessage((Object)request);
        ArtifactResponse response = (ArtifactResponse)this.buildXMLObject(ArtifactResponse.DEFAULT_ELEMENT_NAME);
        response.setInResponseTo("abc123");
        this.opContext.getInboundMessageContext().setMessage((Object)response);
        this.handler.invoke(this.opContext.getInboundMessageContext());
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testSAML2NonMatch() throws MessageHandlerException {
        ArtifactResolve request = (ArtifactResolve)this.buildXMLObject(ArtifactResolve.DEFAULT_ELEMENT_NAME);
        request.setID("abc123");
        this.opContext.getOutboundMessageContext().setMessage((Object)request);
        ArtifactResponse response = (ArtifactResponse)this.buildXMLObject(ArtifactResponse.DEFAULT_ELEMENT_NAME);
        response.setInResponseTo("xyz456");
        this.opContext.getInboundMessageContext().setMessage((Object)response);
        this.handler.invoke(this.opContext.getInboundMessageContext());
    }

    @Test
    public void testSAML1Match() throws MessageHandlerException {
        Request request = (Request)this.buildXMLObject(Request.DEFAULT_ELEMENT_NAME);
        request.setID("abc123");
        this.opContext.getOutboundMessageContext().setMessage((Object)request);
        Response response = (Response)this.buildXMLObject(Response.DEFAULT_ELEMENT_NAME);
        response.setInResponseTo("abc123");
        this.opContext.getInboundMessageContext().setMessage((Object)response);
        this.handler.invoke(this.opContext.getInboundMessageContext());
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testSAML1NonMatch() throws MessageHandlerException {
        Request request = (Request)this.buildXMLObject(Request.DEFAULT_ELEMENT_NAME);
        request.setID("abc123");
        this.opContext.getOutboundMessageContext().setMessage((Object)request);
        Response response = (Response)this.buildXMLObject(Response.DEFAULT_ELEMENT_NAME);
        response.setInResponseTo("xyz456");
        this.opContext.getInboundMessageContext().setMessage((Object)response);
        this.handler.invoke(this.opContext.getInboundMessageContext());
    }
}

