/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.profile.impl.AddNotBeforeConditionToAssertions;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.testing.SAML1ActionTestingSupport;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddNotBeforeConditionToAssertionsTest
extends OpenSAMLInitBaseTestCase {
    private ProfileRequestContext prc;
    private AddNotBeforeConditionToAssertions action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.prc = new RequestContextBuilder().setOutboundMessage((Object)SAML1ActionTestingSupport.buildResponse()).buildProfileRequestContext();
        this.action = new AddNotBeforeConditionToAssertions();
        this.action.initialize();
    }

    @Test
    public void testNoResponse() {
        this.prc.setOutboundMessageContext(null);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoAssertion() {
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
    }

    @Test
    public void testSingleAssertion() {
        Assertion assertion = SAML1ActionTestingSupport.buildAssertion();
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        response.getAssertions().add(assertion);
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertNotNull((Object)assertion.getConditions().getNotBefore());
    }

    @Test
    public void testSingleAssertionWithExistingConditions() {
        SAMLObjectBuilder conditionsBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Conditions.DEFAULT_ELEMENT_NAME);
        Conditions conditions = (Conditions)conditionsBuilder.buildObject();
        Assertion assertion = SAML1ActionTestingSupport.buildAssertion();
        assertion.setConditions(conditions);
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        response.getAssertions().add(assertion);
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertSame((Object)assertion.getConditions(), (Object)conditions);
        Assert.assertNotNull((Object)assertion.getConditions().getNotBefore());
    }

    @Test
    public void testMultipleAssertion() {
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        response.getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)3);
        for (Assertion assertion : response.getAssertions()) {
            Assert.assertNotNull((Object)assertion.getConditions());
            Assert.assertNotNull((Object)assertion.getConditions().getNotBefore());
        }
    }

    @Test
    public void testSAML2Assertion() {
        org.opensaml.saml.saml2.core.Assertion assertion = SAML2ActionTestingSupport.buildAssertion();
        org.opensaml.saml.saml2.core.Response response = SAML2ActionTestingSupport.buildResponse();
        this.prc.getOutboundMessageContext().setMessage((Object)response);
        response.getAssertions().add(assertion);
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertNotNull((Object)assertion.getConditions().getNotBefore());
    }
}

