/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.ext.saml2delrestrict.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.ext.saml2delrestrict.Delegate;
import org.opensaml.saml.ext.saml2delrestrict.DelegationRestrictionType;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DelegationRestrictionTypeTest
extends XMLObjectProviderBaseTestCase {
    private int expectedDelegateChildren;

    public DelegationRestrictionTypeTest() {
        this.singleElementFile = "/org/opensaml/saml/ext/saml2delrestrict/impl/DelegationRestrictionType.xml";
        this.childElementsFile = "/org/opensaml/saml/ext/saml2delrestrict/impl/DelegationRestrictionTypeChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedDelegateChildren = 3;
    }

    @Test
    public void testSingleElementUnmarshall() {
        DelegationRestrictionType drt = (DelegationRestrictionType)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)drt);
    }

    @Test
    public void testChildElementsUnmarshall() {
        DelegationRestrictionType drt = (DelegationRestrictionType)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)drt);
        Assert.assertEquals((int)drt.getDelegates().size(), (int)this.expectedDelegateChildren, (String)"Incorrect # of Delegate Children");
    }

    @Test
    public void testSingleElementMarshall() {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(DelegationRestrictionType.TYPE_NAME);
        DelegationRestrictionType drt = (DelegationRestrictionType)builder.buildObject();
        this.assertXMLEquals(this.expectedDOM, (XMLObject)drt);
    }

    @Test
    public void testChildElementsMarshall() {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(DelegationRestrictionType.TYPE_NAME);
        DelegationRestrictionType drt = (DelegationRestrictionType)builder.buildObject();
        drt.getDelegates().add((Delegate)this.buildXMLObject(Delegate.DEFAULT_ELEMENT_NAME));
        drt.getDelegates().add((Delegate)this.buildXMLObject(Delegate.DEFAULT_ELEMENT_NAME));
        drt.getDelegates().add((Delegate)this.buildXMLObject(Delegate.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)drt);
    }
}

