/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.ext.saml2mdrpi.impl;

import java.time.Instant;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.ext.saml2mdrpi.RegistrationInfo;
import org.opensaml.saml.ext.saml2mdrpi.RegistrationPolicy;
import org.testng.Assert;

public class RegistrationInfoTest
extends XMLObjectProviderBaseTestCase {
    private static String expectedAuthority = "https://www.aai.dfn.de";
    private static Instant expectedRegistrationInstant = Instant.parse("2010-08-11T14:59:01.002Z");
    private static String[] langs = new String[]{"en", "de"};
    private static String[] uris = new String[]{"grhttps://www.aai.dfn.de/en/join/", "https://www.aai.dfn.de/teilnahme/"};

    public RegistrationInfoTest() {
        this.singleElementFile = "/org/opensaml/saml/ext/saml2mdrpi/RegistrationInfo.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/ext/saml2mdrpi/RegistrationInfoOptionalAttr.xml";
        this.childElementsFile = "/org/opensaml/saml/ext/saml2mdrpi/RegistrationInfoChildren.xml";
    }

    public void testSingleElementUnmarshall() {
        RegistrationInfo info = (RegistrationInfo)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)info.getRegistrationAuthority(), (String)expectedAuthority);
    }

    public void testSingleElementOptionalAttributesUnmarshall() {
        RegistrationInfo info = (RegistrationInfo)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)info.getRegistrationAuthority(), (String)expectedAuthority);
        Assert.assertEquals((Object)info.getRegistrationInstant(), (Object)expectedRegistrationInstant);
    }

    public void testSingleElementMarshall() {
        RegistrationInfo info = (RegistrationInfo)this.buildXMLObject(RegistrationInfo.DEFAULT_ELEMENT_NAME);
        info.setRegistrationAuthority(expectedAuthority);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)info);
    }

    public void testSingleElementOptionalAttributesMarshall() {
        RegistrationInfo info = (RegistrationInfo)this.buildXMLObject(RegistrationInfo.DEFAULT_ELEMENT_NAME);
        info.setRegistrationAuthority(expectedAuthority);
        info.setRegistrationInstant(expectedRegistrationInstant);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)info);
    }

    public void testChildElementsUnmarshall() {
        RegistrationInfo info = (RegistrationInfo)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((String)info.getRegistrationAuthority(), (String)expectedAuthority);
        Assert.assertEquals((Object)info.getRegistrationInstant(), (Object)expectedRegistrationInstant);
        RegistrationPolicy policy = (RegistrationPolicy)info.getRegistrationPolicies().get(0);
        Assert.assertEquals((String)policy.getXMLLang(), (String)langs[0]);
        Assert.assertEquals((String)policy.getURI(), (String)uris[0]);
        policy = (RegistrationPolicy)info.getRegistrationPolicies().get(1);
        Assert.assertEquals((String)policy.getXMLLang(), (String)langs[1]);
        Assert.assertEquals((String)policy.getURI(), (String)uris[1]);
    }

    public void testChildElementsMarshall() {
        RegistrationInfo info = (RegistrationInfo)this.buildXMLObject(RegistrationInfo.DEFAULT_ELEMENT_NAME);
        info.setRegistrationAuthority(expectedAuthority);
        info.setRegistrationInstant(expectedRegistrationInstant);
        for (int i = 0; i < 2; ++i) {
            RegistrationPolicy policy = (RegistrationPolicy)this.buildXMLObject(RegistrationPolicy.DEFAULT_ELEMENT_NAME);
            policy.setURI(uris[i]);
            policy.setXMLLang(langs[i]);
            info.getRegistrationPolicies().add(policy);
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)info);
    }
}

