/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.ext.saml2mdui.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.saml.ext.saml2mdui.Description;
import org.opensaml.saml.ext.saml2mdui.DisplayName;
import org.opensaml.saml.ext.saml2mdui.InformationURL;
import org.opensaml.saml.ext.saml2mdui.Keywords;
import org.opensaml.saml.ext.saml2mdui.Logo;
import org.opensaml.saml.ext.saml2mdui.PrivacyStatementURL;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UIInfoTest
extends XMLObjectProviderBaseTestCase {
    private final int expectedDisplayNamesCount = 3;
    private final int expectedDescriptionsCount = 1;
    private final int expectedKeywordsCount = 1;
    private final int expectedLogosCount = 1;
    private final int expectedInformationURLsCount = 1;
    private final int expectedPrivacyStatementURLsCount = 1;
    private final int expectedSimpleElementCount = 1;

    public UIInfoTest() {
        this.singleElementFile = "/org/opensaml/saml/ext/saml2mdui/UIInfo.xml";
        this.childElementsFile = "/org/opensaml/saml/ext/saml2mdui/UIInfoChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        UIInfo uiinfo = (UIInfo)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)uiinfo, (String)"UIInfo");
    }

    @Test
    public void testSingleElementMarshall() {
        UIInfo uiinfo = (UIInfo)this.buildXMLObject(UIInfo.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)uiinfo);
    }

    @Test
    public void testChildElementsUnmarshall() {
        UIInfo uiinfo = (UIInfo)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)uiinfo.getDisplayNames().size(), (int)3, (String)"<DisplayName> count");
        Assert.assertEquals((int)uiinfo.getDescriptions().size(), (int)1, (String)"<Descriptions> count");
        Assert.assertEquals((int)uiinfo.getLogos().size(), (int)1, (String)"<Logos> count");
        Assert.assertEquals((int)uiinfo.getKeywords().size(), (int)1, (String)"<Keywords> count");
        Assert.assertEquals((int)uiinfo.getInformationURLs().size(), (int)1, (String)"<InformationURLs> count");
        Assert.assertEquals((int)uiinfo.getPrivacyStatementURLs().size(), (int)1, (String)"<PrivacyStatementURLs> count");
        Assert.assertEquals((int)uiinfo.getXMLObjects(SimpleXMLObject.ELEMENT_NAME).size(), (int)1, (String)"<test:SimpleElement> count");
    }

    @Test
    public void testChildElementsMarshall() {
        UIInfo uiinfo = (UIInfo)this.buildXMLObject(UIInfo.DEFAULT_ELEMENT_NAME);
        uiinfo.getDisplayNames().add((DisplayName)this.buildXMLObject(DisplayName.DEFAULT_ELEMENT_NAME));
        uiinfo.getDescriptions().add((Description)this.buildXMLObject(Description.DEFAULT_ELEMENT_NAME));
        uiinfo.getKeywords().add((Keywords)this.buildXMLObject(Keywords.DEFAULT_ELEMENT_NAME));
        uiinfo.getKeywords().add((Keywords)this.buildXMLObject(Keywords.DEFAULT_ELEMENT_NAME));
        uiinfo.getInformationURLs().add((InformationURL)this.buildXMLObject(InformationURL.DEFAULT_ELEMENT_NAME));
        uiinfo.getDisplayNames().add((DisplayName)this.buildXMLObject(DisplayName.DEFAULT_ELEMENT_NAME));
        uiinfo.getLogos().add((Logo)this.buildXMLObject(Logo.DEFAULT_ELEMENT_NAME));
        uiinfo.getPrivacyStatementURLs().add((PrivacyStatementURL)this.buildXMLObject(PrivacyStatementURL.DEFAULT_ELEMENT_NAME));
        uiinfo.getXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        uiinfo.getDisplayNames().add((DisplayName)this.buildXMLObject(DisplayName.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)uiinfo);
    }
}

