/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import java.util.Set;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.filter.impl.BasicDynamicTrustedNamesStrategy;
import org.opensaml.saml.saml2.metadata.AffiliationDescriptor;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BasicDynamicTrustedNamesStrategyTest
extends XMLObjectBaseTestCase {
    private BasicDynamicTrustedNamesStrategy strategy = new BasicDynamicTrustedNamesStrategy();

    @Test
    public void testEntityDescriptor() {
        EntityDescriptor target = (EntityDescriptor)this.buildXMLObject(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        target.setEntityID("foo");
        Set result = this.strategy.apply((XMLObject)target);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)1);
        Assert.assertTrue((boolean)result.contains("foo"));
    }

    @Test
    public void testEntitiesDescriptor() {
        EntitiesDescriptor target = (EntitiesDescriptor)this.buildXMLObject(EntitiesDescriptor.DEFAULT_ELEMENT_NAME);
        target.setName("foo");
        Set result = this.strategy.apply((XMLObject)target);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)1);
        Assert.assertTrue((boolean)result.contains("foo"));
    }

    @Test
    public void testRoleDescriptor() {
        EntityDescriptor parent = (EntityDescriptor)this.buildXMLObject(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        parent.setEntityID("foo");
        SPSSODescriptor target = (SPSSODescriptor)this.buildXMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        parent.getRoleDescriptors().add(target);
        Set result = this.strategy.apply((XMLObject)target);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)1);
        Assert.assertTrue((boolean)result.contains("foo"));
    }

    @Test
    public void testAffiliationDescriptor() {
        EntityDescriptor parent = (EntityDescriptor)this.buildXMLObject(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        parent.setEntityID("foo");
        AffiliationDescriptor target = (AffiliationDescriptor)this.buildXMLObject(AffiliationDescriptor.DEFAULT_ELEMENT_NAME);
        target.setOwnerID("bar");
        parent.setAffiliationDescriptor(target);
        Set result = this.strategy.apply((XMLObject)target);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)2);
        Assert.assertTrue((boolean)result.contains("foo"));
        Assert.assertTrue((boolean)result.contains("bar"));
    }

    @Test
    public void testUnknown() {
        XMLObject target = this.buildXMLObject(simpleXMLObjectQName);
        Set result = this.strategy.apply(target);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testNull() {
        XMLObject target = null;
        Set result = this.strategy.apply(target);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
    }
}

