/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.ByReferenceMetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.NameIDFormatFilter;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ByReferenceMetadataFilterTest
extends XMLObjectBaseTestCase
implements Predicate<EntityDescriptor> {
    protected MetadataResolver resolver;
    private FilesystemMetadataResolver metadataProvider;
    private ByReferenceMetadataFilter refFilter;
    private NameIDFormatFilter nameIDFilter;
    private Collection<String> formats;

    @BeforeMethod
    protected void setUp() throws URISyntaxException, ResolverException {
        URL mdURL = ByReferenceMetadataFilterTest.class.getResource("/org/opensaml/saml/saml2/metadata/InCommon-metadata.xml");
        File mdFile = new File(mdURL.toURI());
        this.metadataProvider = new FilesystemMetadataResolver(mdFile);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("ICMD");
        this.refFilter = new ByReferenceMetadataFilter();
        this.metadataProvider.setMetadataFilter((MetadataFilter)this.refFilter);
        this.nameIDFilter = new NameIDFormatFilter();
        this.formats = Arrays.asList("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos");
    }

    @Test
    public void notApplicable() throws ComponentInitializationException, ResolverException {
        this.nameIDFilter.setRules(Collections.singletonMap(this, this.formats));
        this.nameIDFilter.initialize();
        this.refFilter.setFilterMappings(Collections.singletonMap("Foo", this.nameIDFilter));
        this.metadataProvider.initialize();
        this.validate(false);
    }

    @Test
    public void applicable() throws ComponentInitializationException, ResolverException {
        this.nameIDFilter.setRules(Collections.singletonMap(this, this.formats));
        this.nameIDFilter.initialize();
        this.refFilter.setFilterMappings(Collections.singletonMap(List.of("ICMD", "Foo"), this.nameIDFilter));
        this.metadataProvider.initialize();
        this.validate(true);
    }

    private void validate(boolean applied) throws ResolverException {
        EntityIdCriterion key = new EntityIdCriterion("https://carmenwiki.osu.edu/shibboleth");
        EntityDescriptor entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{key}));
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((int)entity.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getNameIDFormats().size(), (int)(applied ? 3 : 1));
        key = new EntityIdCriterion("https://cms.psu.edu/Shibboleth");
        entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{key}));
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((int)entity.getSPSSODescriptor("urn:oasis:names:tc:SAML:1.1:protocol").getNameIDFormats().size(), (int)1);
    }

    @Override
    public boolean test(EntityDescriptor input) {
        return input.getEntityID().equals("https://carmenwiki.osu.edu/shibboleth");
    }
}

