/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.saml.metadata.EntityGroupName;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataNodeProcessor;
import org.opensaml.saml.metadata.resolver.filter.impl.EntitiesDescriptorNameProcessor;
import org.opensaml.saml.metadata.resolver.filter.impl.NodeProcessingMetadataFilter;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolverTest;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EntitiesDescriptorNameProcessorTest
extends XMLObjectBaseTestCase {
    private FilesystemMetadataResolver metadataProvider;
    private File mdFile;
    private NodeProcessingMetadataFilter metadataFilter;
    private ArrayList<MetadataNodeProcessor> processors;

    @BeforeMethod
    protected void setUp() throws Exception {
        URL mdURL = FilesystemMetadataResolverTest.class.getResource("/org/opensaml/saml/metadata/resolver/filter/impl/EntitiesDescriptor-Name-metadata.xml");
        this.mdFile = new File(mdURL.toURI());
        this.processors = new ArrayList();
        this.processors.add((MetadataNodeProcessor)new EntitiesDescriptorNameProcessor());
        this.metadataFilter = new NodeProcessingMetadataFilter();
        this.metadataFilter.setNodeProcessors(this.processors);
        this.metadataFilter.initialize();
        this.metadataProvider = new FilesystemMetadataResolver(this.mdFile);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setMetadataFilter((MetadataFilter)this.metadataFilter);
        this.metadataProvider.setId("Test");
        this.metadataProvider.initialize();
    }

    @Test
    public void testGroupHierarchy() throws ResolverException {
        EntityGroupName groupTop = new EntityGroupName("GroupTop");
        EntityGroupName groupSub1 = new EntityGroupName("GroupSub1");
        EntityGroupName groupSub2 = new EntityGroupName("GroupSub2");
        EntityGroupName groupSub2A = new EntityGroupName("GroupSub2A");
        EntityDescriptor entityDescriptor = null;
        List groups = null;
        entityDescriptor = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://idp-top.example.org")}));
        groups = entityDescriptor.getObjectMetadata().get(EntityGroupName.class);
        Assert.assertEquals((int)groups.size(), (int)1);
        Assert.assertTrue((boolean)groups.contains(groupTop));
        entityDescriptor = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://idp-sub1.example.org")}));
        groups = entityDescriptor.getObjectMetadata().get(EntityGroupName.class);
        Assert.assertEquals((int)groups.size(), (int)2);
        Assert.assertTrue((boolean)groups.contains(groupTop));
        Assert.assertTrue((boolean)groups.contains(groupSub1));
        entityDescriptor = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://idp-sub2.example.org")}));
        groups = entityDescriptor.getObjectMetadata().get(EntityGroupName.class);
        Assert.assertEquals((int)groups.size(), (int)2);
        Assert.assertTrue((boolean)groups.contains(groupTop));
        Assert.assertTrue((boolean)groups.contains(groupSub2));
        entityDescriptor = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://idp-sub2a.example.org")}));
        groups = entityDescriptor.getObjectMetadata().get(EntityGroupName.class);
        Assert.assertEquals((int)groups.size(), (int)3);
        Assert.assertTrue((boolean)groups.contains(groupTop));
        Assert.assertTrue((boolean)groups.contains(groupSub2));
        Assert.assertTrue((boolean)groups.contains(groupSub2A));
    }
}

