/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import net.shibboleth.ext.spring.resource.ResourceHelper;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.saml.common.xml.SAMLSchemaBuilder;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.SchemaValidationFilter;
import org.opensaml.saml.metadata.resolver.impl.ResourceBackedMetadataResolver;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SchemaValidationFilterTest
extends XMLObjectBaseTestCase {
    @Test
    public void testValid() throws Exception {
        ResourceBackedMetadataResolver metadataProvider = new ResourceBackedMetadataResolver(ResourceHelper.of((Resource)new ClassPathResource("org/opensaml/saml/saml2/metadata/valid-metadata.xml")));
        metadataProvider.setParserPool(parserPool);
        metadataProvider.setId("test");
        metadataProvider.setMetadataFilter((MetadataFilter)new SchemaValidationFilter(new SAMLSchemaBuilder(SAMLSchemaBuilder.SAML1Version.SAML_11)));
        metadataProvider.initialize();
    }

    @Test
    public void testStrict() throws Exception {
        ResourceBackedMetadataResolver metadataProvider = new ResourceBackedMetadataResolver(ResourceHelper.of((Resource)new ClassPathResource("org/opensaml/saml/saml2/metadata/valid-metadata.xml")));
        metadataProvider.setParserPool(parserPool);
        metadataProvider.setId("test");
        metadataProvider.setMetadataFilter((MetadataFilter)new SchemaValidationFilter(new SAMLSchemaBuilder(SAMLSchemaBuilder.SAML1Version.SAML_11, true)));
        metadataProvider.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testStrictInvalid() throws Exception {
        ResourceBackedMetadataResolver metadataProvider = new ResourceBackedMetadataResolver(ResourceHelper.of((Resource)new ClassPathResource("org/opensaml/saml/saml2/metadata/invalid-metadata.xml")));
        metadataProvider.setParserPool(parserPool);
        metadataProvider.setId("test");
        metadataProvider.setMetadataFilter((MetadataFilter)new SchemaValidationFilter(new SAMLSchemaBuilder(SAMLSchemaBuilder.SAML1Version.SAML_11, true)));
        metadataProvider.initialize();
        Assert.fail((String)"Should have raised schema validation error");
    }
}

