/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.script.ScriptException;
import net.shibboleth.ext.spring.resource.ResourceHelper;
import net.shibboleth.utilities.java.support.resource.Resource;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.metadata.resolver.filter.impl.ScriptedTrustedNamesFunction;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.springframework.core.io.ClassPathResource;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ScriptedFunctionTest
extends XMLObjectBaseTestCase {
    static final String SCRIPT_8 = "JavaString=Java.type(\"java.lang.String\"); JavaSet = Java.type(\"java.util.HashSet\");set = new JavaSet();set.add(new JavaString(\"String\"));set";
    static final String FILE_8 = "/org/opensaml/saml/metadata/resolver/filter/impl/script8.js";

    private XMLObject makeObject() {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        return builder.buildObject();
    }

    @Test
    public void inlineScript() throws ScriptException {
        Set s = ScriptedTrustedNamesFunction.inlineScript((String)SCRIPT_8).apply(this.makeObject());
        Assert.assertEquals((int)s.size(), (int)1);
        Assert.assertTrue((boolean)s.contains("String"));
    }

    @Test
    public void fileScript() throws ScriptException, IOException {
        Resource r = ResourceHelper.of((org.springframework.core.io.Resource)new ClassPathResource(FILE_8));
        Set result = ScriptedTrustedNamesFunction.resourceScript((Resource)r).apply(this.makeObject());
        Assert.assertEquals((int)result.size(), (int)1);
        Assert.assertTrue((boolean)result.contains("String"));
    }

    @Test
    public void customScript() throws ScriptException {
        ScriptedTrustedNamesFunction what = ScriptedTrustedNamesFunction.inlineScript((String)"custom;");
        what.setCustomObject(Collections.singleton("String"));
        Set s = what.apply(this.makeObject());
        Assert.assertEquals((int)s.size(), (int)1);
        Assert.assertTrue((boolean)s.contains("String"));
    }
}

