/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FilesystemMetadataResolverTest
extends XMLObjectBaseTestCase {
    private FilesystemMetadataResolver metadataProvider;
    private File mdFile;
    private String entityID;
    private CriteriaSet criteriaSet;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.entityID = "urn:mace:incommon:washington.edu";
        URL mdURL = FilesystemMetadataResolverTest.class.getResource("/org/opensaml/saml/saml2/metadata/InCommon-metadata.xml");
        this.mdFile = new File(mdURL.toURI());
        this.criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.entityID)});
    }

    @Test
    public void testGetEntityDescriptor() throws ResolverException {
        try {
            this.metadataProvider = new FilesystemMetadataResolver(this.mdFile);
            this.metadataProvider.setParserPool(parserPool);
            this.metadataProvider.setId("test");
            this.metadataProvider.initialize();
            Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertTrue((boolean)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertNull((Object)this.metadataProvider.getLastFailureCause());
        }
        catch (ComponentInitializationException e) {
            Assert.fail((String)"Valid metdata failed init");
        }
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }

    @Test
    public void testNonexistentMetadataFile() throws ResolverException, ComponentInitializationException {
        try {
            this.metadataProvider = new FilesystemMetadataResolver(new File("I-Dont-Exist.xml"));
            this.metadataProvider.setParserPool(parserPool);
            this.metadataProvider.setId("test");
            this.metadataProvider.initialize();
            Assert.fail((String)"Init should have thrown");
        }
        catch (ComponentInitializationException e) {
            Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertFalse((boolean)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertNotNull((Object)this.metadataProvider.getLastFailureCause());
            Assert.assertTrue((boolean)ResolverException.class.isInstance(this.metadataProvider.getLastFailureCause()));
        }
    }

    @Test
    public void testInvalidMetadataFile() throws IOException, ResolverException, ComponentInitializationException {
        File targetFile = new File(System.getProperty("java.io.tmpdir"), "filesystem-md-provider-test");
        if (targetFile.exists()) {
            Assert.assertTrue((boolean)targetFile.delete());
        }
        Assert.assertTrue((boolean)targetFile.mkdir());
        Assert.assertTrue((boolean)targetFile.exists());
        Assert.assertTrue((boolean)targetFile.isDirectory());
        try {
            this.metadataProvider = new FilesystemMetadataResolver(targetFile);
            this.metadataProvider.setParserPool(parserPool);
            this.metadataProvider.setId("test");
            this.metadataProvider.initialize();
            Assert.fail((String)"Init should have thrown");
        }
        catch (ComponentInitializationException e) {
            Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertFalse((boolean)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertNotNull((Object)this.metadataProvider.getLastFailureCause());
            Assert.assertTrue((boolean)ResolverException.class.isInstance(this.metadataProvider.getLastFailureCause()));
        }
        finally {
            targetFile.delete();
        }
    }

    @Test
    public void testUnreadableMetadataFile() throws IOException, ResolverException, ComponentInitializationException {
        File targetFile = File.createTempFile("filesystem-md-provider-test", "xml");
        Assert.assertTrue((boolean)targetFile.exists());
        Assert.assertTrue((boolean)targetFile.isFile());
        Assert.assertTrue((boolean)targetFile.canRead());
        try {
            this.metadataProvider = new FilesystemMetadataResolver(targetFile);
            this.metadataProvider.setParserPool(parserPool);
            this.metadataProvider.setId("test");
            this.metadataProvider.initialize();
        }
        catch (ComponentInitializationException e) {
            Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertFalse((boolean)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertNotNull((Object)this.metadataProvider.getLastFailureCause());
            Assert.assertTrue((boolean)ResolverException.class.isInstance(this.metadataProvider.getLastFailureCause()));
        }
        finally {
            targetFile.delete();
        }
    }

    @Test
    public void testDisappearingMetadataFile() throws IOException, ResolverException {
        File targetFile = new File(System.getProperty("java.io.tmpdir"), "filesystem-md-provider-disappearing.xml");
        if (targetFile.exists()) {
            Assert.assertTrue((boolean)targetFile.delete());
        }
        Files.copy((File)this.mdFile, (File)targetFile);
        Assert.assertTrue((boolean)targetFile.exists());
        Assert.assertTrue((boolean)targetFile.canRead());
        try {
            this.metadataProvider = new FilesystemMetadataResolver(targetFile);
            this.metadataProvider.setParserPool(parserPool);
            this.metadataProvider.setId("test");
            this.metadataProvider.initialize();
            Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertTrue((boolean)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertNull((Object)this.metadataProvider.getLastFailureCause());
        }
        catch (ComponentInitializationException e) {
            Assert.fail((String)("Filesystem metadata provider init failed with file: " + targetFile.getAbsolutePath()));
        }
        Assert.assertTrue((boolean)targetFile.delete());
        try {
            this.metadataProvider.refresh();
            Assert.fail((String)"Refresh should have thrown");
        }
        catch (ResolverException e) {
            Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertFalse((boolean)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertNotNull((Object)this.metadataProvider.getLastFailureCause());
            Assert.assertTrue((boolean)ResolverException.class.isInstance(this.metadataProvider.getLastFailureCause()));
        }
    }

    @Test
    public void testRecoveryFromNoFailFast() throws IOException, InterruptedException {
        File targetFile = new File(System.getProperty("java.io.tmpdir"), "filesystem-md-provider-failfast.xml");
        if (targetFile.exists()) {
            Assert.assertTrue((boolean)targetFile.delete());
        }
        try {
            this.metadataProvider = new FilesystemMetadataResolver(targetFile);
            this.metadataProvider.setFailFastInitialization(false);
            this.metadataProvider.setParserPool(parserPool);
            this.metadataProvider.setId("test");
            this.metadataProvider.initialize();
            Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertFalse((boolean)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertNotNull((Object)this.metadataProvider.getLastFailureCause());
            Assert.assertTrue((boolean)ResolverException.class.isInstance(this.metadataProvider.getLastFailureCause()));
        }
        catch (ComponentInitializationException | ResolverException e) {
            Assert.fail((String)"Filesystem metadata provider init failed with non-existent file and fail fast = false");
        }
        try {
            EntityDescriptor entity = this.metadataProvider.resolveSingle(this.criteriaSet);
            Assert.assertNull((Object)entity, (String)"Retrieved entity descriptor was not null");
        }
        catch (ResolverException e) {
            Assert.fail((String)"Metadata provider behaved non-gracefully when initialized with fail fast = false");
        }
        Thread.sleep(2000L);
        Files.copy((File)this.mdFile, (File)targetFile);
        Assert.assertTrue((boolean)targetFile.exists());
        Assert.assertTrue((boolean)targetFile.canRead());
        try {
            this.metadataProvider.refresh();
            Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertTrue((boolean)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertNull((Object)this.metadataProvider.getLastFailureCause());
            EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
            Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        }
        catch (ResolverException e) {
            Assert.fail((String)"Filesystem metadata provider refresh failed recovery from initial init failure");
        }
    }

    @Test
    public void testExpiredMetadataWithValidRequiredAndNoFailFast() throws URISyntaxException, ResolverException {
        URL mdURL = FilesystemMetadataResolverTest.class.getResource("/org/opensaml/saml/saml2/metadata/simple-metadata-expired.xml");
        File targetFile = new File(mdURL.toURI());
        try {
            this.metadataProvider = new FilesystemMetadataResolver(targetFile);
            this.metadataProvider.setFailFastInitialization(false);
            this.metadataProvider.setRequireValidMetadata(true);
            this.metadataProvider.setId("test");
            this.metadataProvider.setParserPool(parserPool);
            this.metadataProvider.initialize();
            Assert.assertNotNull((Object)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertFalse((boolean)this.metadataProvider.wasLastRefreshSuccess());
            Assert.assertNotNull((Object)this.metadataProvider.getLastFailureCause());
            Assert.assertTrue((boolean)ResolverException.class.isInstance(this.metadataProvider.getLastFailureCause()));
        }
        catch (ComponentInitializationException | ResolverException e) {
            Assert.fail((String)"Filesystem metadata provider init failed with expired file and fail fast = false");
        }
        EntityDescriptor entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://idp.example.org")}));
        Assert.assertNull((Object)entity);
    }
}

