/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Function;
import net.shibboleth.utilities.java.support.codec.StringDigester;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.test.repository.RepositorySupport;
import net.shibboleth.utilities.java.support.velocity.VelocityEngine;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.saml.common.binding.artifact.SAMLArtifact;
import org.opensaml.saml.criterion.ArtifactCriterion;
import org.opensaml.saml.metadata.resolver.impl.FunctionDrivenDynamicHTTPMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.HTTPEntityIDRequestURLBuilder;
import org.opensaml.saml.metadata.resolver.impl.HTTPMetadataResolverTest;
import org.opensaml.saml.metadata.resolver.impl.MetadataQueryProtocolRequestURLBuilder;
import org.opensaml.saml.metadata.resolver.impl.SAMLArtifactURLBuilder;
import org.opensaml.saml.metadata.resolver.impl.TemplateRequestURLBuilder;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactType0004;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FunctionDrivenDynamicHTTPMetadataResolverTest
extends XMLObjectBaseTestCase {
    private FunctionDrivenDynamicHTTPMetadataResolver resolver;
    private HttpClientBuilder httpClientBuilder;

    @BeforeMethod
    public void setUp() {
        this.httpClientBuilder = new HttpClientBuilder();
    }

    @AfterMethod
    public void tearDown() {
        if (this.resolver != null) {
            this.resolver.destroy();
        }
    }

    @Test
    public void testTemplateFromRepoDefaultContentTypes() throws Exception {
        String template = RepositorySupport.buildHTTPResourceURL((String)"java-opensaml", (String)"opensaml-saml-impl/src/test/resources/org/opensaml/saml/metadata/resolver/impl/${entityID}.xml", (boolean)false);
        String entityID = "https://www.example.org/sp";
        TemplateRequestURLBuilder requestURLBuilder = new TemplateRequestURLBuilder(VelocityEngine.newVelocityEngine(), template, TemplateRequestURLBuilder.EncodingStyle.path, (Function)new StringDigester("SHA-1", StringDigester.OutputFormat.HEX_LOWER));
        this.resolver = new FunctionDrivenDynamicHTTPMetadataResolver(this.httpClientBuilder.buildClient());
        this.resolver.setId("myDynamicResolver");
        this.resolver.setParserPool(parserPool);
        this.resolver.setRequestURLBuilder((Function)requestURLBuilder);
        this.resolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)});
        EntityDescriptor ed = this.resolver.resolveSingle(criteriaSet);
        Assert.assertNotNull((Object)ed);
        Assert.assertEquals((String)ed.getEntityID(), (String)entityID);
        Assert.assertNull((Object)ed.getDOM());
    }

    @Test(enabled=false)
    public void testTemplateFromRepoWithExplicitContentType() throws Exception {
        String template = RepositorySupport.buildHTTPResourceURL((String)"java-opensaml", (String)"opensaml-saml-impl/src/test/resources/org/opensaml/saml/metadata/resolver/impl/${entityID}.xml", (boolean)false);
        String entityID = "https://www.example.org/sp";
        TemplateRequestURLBuilder requestURLBuilder = new TemplateRequestURLBuilder(VelocityEngine.newVelocityEngine(), template, TemplateRequestURLBuilder.EncodingStyle.path, (Function)new StringDigester("SHA-1", StringDigester.OutputFormat.HEX_LOWER));
        this.resolver = new FunctionDrivenDynamicHTTPMetadataResolver(this.httpClientBuilder.buildClient());
        this.resolver.setId("myDynamicResolver");
        this.resolver.setParserPool(parserPool);
        this.resolver.setRequestURLBuilder((Function)requestURLBuilder);
        this.resolver.setSupportedContentTypes(Arrays.asList("application/samlmetadata+xml", "application/xml", "text/xml", "TEXT/PLAIN"));
        this.resolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)});
        EntityDescriptor ed = this.resolver.resolveSingle(criteriaSet);
        Assert.assertNotNull((Object)ed);
        Assert.assertEquals((String)ed.getEntityID(), (String)entityID);
        Assert.assertNull((Object)ed.getDOM());
    }

    @Test(enabled=false)
    public void testTemplateFromRepoUnsupportedContentType() throws Exception {
        String template = RepositorySupport.buildHTTPSResourceURL((String)"java-opensaml", (String)"opensaml-saml-impl/src/test/resources/org/opensaml/saml/metadata/resolver/impl/${entityID}.xml");
        String entityID = "https://www.example.org/sp";
        TemplateRequestURLBuilder requestURLBuilder = new TemplateRequestURLBuilder(VelocityEngine.newVelocityEngine(), template, TemplateRequestURLBuilder.EncodingStyle.path, (Function)new StringDigester("SHA-1", StringDigester.OutputFormat.HEX_LOWER));
        this.resolver = new FunctionDrivenDynamicHTTPMetadataResolver(this.httpClientBuilder.buildClient());
        this.resolver.setId("myDynamicResolver");
        this.resolver.setParserPool(parserPool);
        this.resolver.setRequestURLBuilder((Function)requestURLBuilder);
        this.resolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)});
        EntityDescriptor ed = this.resolver.resolveSingle(criteriaSet);
        Assert.assertNull((Object)ed);
    }

    @Test
    public void testTemplateNonexistentDomain() throws Exception {
        String template = "http://bogus.example.org/metadata?entityID=${entityID}";
        String entityID = "https://www.example.org/sp";
        TemplateRequestURLBuilder requestURLBuilder = new TemplateRequestURLBuilder(VelocityEngine.newVelocityEngine(), template, TemplateRequestURLBuilder.EncodingStyle.form);
        this.resolver = new FunctionDrivenDynamicHTTPMetadataResolver(this.httpClientBuilder.buildClient());
        this.resolver.setId("myDynamicResolver");
        this.resolver.setParserPool(parserPool);
        this.resolver.setRequestURLBuilder((Function)requestURLBuilder);
        this.resolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)});
        EntityDescriptor ed = this.resolver.resolveSingle(criteriaSet);
        Assert.assertNull((Object)ed);
    }

    @Test
    public void testTemplateNonexistentPath() throws Exception {
        String template = "http://test.shibboleth.net/unittests/metadata?entityID=${entityID}";
        String entityID = "https://www.example.org/sp";
        TemplateRequestURLBuilder requestURLBuilder = new TemplateRequestURLBuilder(VelocityEngine.newVelocityEngine(), template, TemplateRequestURLBuilder.EncodingStyle.form);
        this.resolver = new FunctionDrivenDynamicHTTPMetadataResolver(this.httpClientBuilder.buildClient());
        this.resolver.setId("myDynamicResolver");
        this.resolver.setParserPool(parserPool);
        this.resolver.setRequestURLBuilder((Function)requestURLBuilder);
        this.resolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)});
        EntityDescriptor ed = this.resolver.resolveSingle(criteriaSet);
        Assert.assertNull((Object)ed);
    }

    @Test
    public void testWellKnownLocation() throws Exception {
        String entityID = "https://test.shibboleth.net/shibboleth";
        HTTPEntityIDRequestURLBuilder requestURLBuilder = new HTTPEntityIDRequestURLBuilder();
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildSocketFactory());
        this.resolver = new FunctionDrivenDynamicHTTPMetadataResolver(this.httpClientBuilder.buildClient());
        this.resolver.setId("myDynamicResolver");
        this.resolver.setParserPool(parserPool);
        this.resolver.setRequestURLBuilder((Function)requestURLBuilder);
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildExplicitKeyTrustEngine("test.shibboleth.net.crt"));
        this.resolver.setHttpClientSecurityParameters(params);
        this.resolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)});
        EntityDescriptor ed = this.resolver.resolveSingle(criteriaSet);
        Assert.assertNotNull((Object)ed);
        Assert.assertEquals((String)ed.getEntityID(), (String)entityID);
        Assert.assertNull((Object)ed.getDOM());
    }

    @Test
    public void testMDQ() throws Exception {
        String baseURL = "https://mdq.incommon.org";
        String entityID = "urn:mace:incommon:osu.edu";
        MetadataQueryProtocolRequestURLBuilder requestURLBuilder = new MetadataQueryProtocolRequestURLBuilder(baseURL);
        this.httpClientBuilder.setConnectionDisregardTLSCertificate(true);
        this.resolver = new FunctionDrivenDynamicHTTPMetadataResolver(this.httpClientBuilder.buildClient());
        this.resolver.setId("myDynamicResolver");
        this.resolver.setParserPool(parserPool);
        this.resolver.setRequestURLBuilder((Function)requestURLBuilder);
        this.resolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)});
        EntityDescriptor ed = this.resolver.resolveSingle(criteriaSet);
        Assert.assertNotNull((Object)ed);
        Assert.assertEquals((String)ed.getEntityID(), (String)entityID);
        Assert.assertNull((Object)ed.getDOM());
    }

    @Test
    public void testMDQViaArtifact() throws Exception {
        String baseURL = "https://mdq.incommon.org";
        String entityID = "urn:mace:incommon:osu.edu";
        MetadataQueryProtocolRequestURLBuilder requestURLBuilder = new MetadataQueryProtocolRequestURLBuilder(baseURL, Collections.singletonList(new SAMLArtifactURLBuilder()));
        this.httpClientBuilder.setConnectionDisregardTLSCertificate(true);
        this.resolver = new FunctionDrivenDynamicHTTPMetadataResolver(this.httpClientBuilder.buildClient());
        this.resolver.setId("myDynamicResolver");
        this.resolver.setParserPool(parserPool);
        this.resolver.setRequestURLBuilder((Function)requestURLBuilder);
        this.resolver.initialize();
        MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
        byte[] entityIDSourceID = sha1Digester.digest(entityID.getBytes("UTF-8"));
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        byte[] messageHandle = new byte[20];
        secureRandom.nextBytes(messageHandle);
        SAML2ArtifactType0004 sourceIDArtifact = new SAML2ArtifactType0004(new byte[]{0, 0}, entityIDSourceID, messageHandle);
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new ArtifactCriterion((SAMLArtifact)sourceIDArtifact)});
        EntityDescriptor ed = this.resolver.resolveSingle(criteriaSet);
        Assert.assertNotNull((Object)ed);
        Assert.assertEquals((String)ed.getEntityID(), (String)entityID);
        Assert.assertNull((Object)ed.getDOM());
    }

    @Test
    public void testTrustEngineSocketFactoryNoHTTPSNoTrustEngine() throws Exception {
        String template = RepositorySupport.buildHTTPResourceURL((String)"java-opensaml", (String)"opensaml-saml-impl/src/test/resources/org/opensaml/saml/metadata/resolver/impl/${entityID}.xml", (boolean)false);
        String entityID = "https://www.example.org/sp";
        TemplateRequestURLBuilder requestURLBuilder = new TemplateRequestURLBuilder(VelocityEngine.newVelocityEngine(), template, TemplateRequestURLBuilder.EncodingStyle.path, (Function)new StringDigester("SHA-1", StringDigester.OutputFormat.HEX_LOWER));
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildSocketFactory());
        this.resolver = new FunctionDrivenDynamicHTTPMetadataResolver(this.httpClientBuilder.buildClient());
        this.resolver.setId("myDynamicResolver");
        this.resolver.setParserPool(parserPool);
        this.resolver.setRequestURLBuilder((Function)requestURLBuilder);
        this.resolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)});
        EntityDescriptor ed = this.resolver.resolveSingle(criteriaSet);
        Assert.assertNotNull((Object)ed);
        Assert.assertEquals((String)ed.getEntityID(), (String)entityID);
        Assert.assertNull((Object)ed.getDOM());
    }

    @Test
    public void testTrustEngineSocketFactoryNoHTTPSWithTrustEngine() throws Exception {
        String template = RepositorySupport.buildHTTPResourceURL((String)"java-opensaml", (String)"opensaml-saml-impl/src/test/resources/org/opensaml/saml/metadata/resolver/impl/${entityID}.xml", (boolean)false);
        String entityID = "https://www.example.org/sp";
        TemplateRequestURLBuilder requestURLBuilder = new TemplateRequestURLBuilder(VelocityEngine.newVelocityEngine(), template, TemplateRequestURLBuilder.EncodingStyle.path, (Function)new StringDigester("SHA-1", StringDigester.OutputFormat.HEX_LOWER));
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildSocketFactory());
        this.resolver = new FunctionDrivenDynamicHTTPMetadataResolver(this.httpClientBuilder.buildClient());
        this.resolver.setId("myDynamicResolver");
        this.resolver.setParserPool(parserPool);
        this.resolver.setRequestURLBuilder((Function)requestURLBuilder);
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildExplicitKeyTrustEngine("repo-entity.crt"));
        this.resolver.setHttpClientSecurityParameters(params);
        this.resolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)});
        EntityDescriptor ed = this.resolver.resolveSingle(criteriaSet);
        Assert.assertNotNull((Object)ed);
        Assert.assertEquals((String)ed.getEntityID(), (String)entityID);
        Assert.assertNull((Object)ed.getDOM());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHTTPSNoTrustEngine() throws Exception {
        try {
            System.setProperty("javax.net.ssl.trustStore", ((Object)((Object)this)).getClass().getResource("repo.truststore.jks").getFile());
            System.setProperty("javax.net.ssl.trustStorePassword", "shibboleth");
            String template = RepositorySupport.buildHTTPSResourceURL((String)"java-opensaml", (String)"opensaml-saml-impl/src/test/resources/org/opensaml/saml/metadata/resolver/impl/${entityID}.xml");
            String entityID = "https://www.example.org/sp";
            TemplateRequestURLBuilder requestURLBuilder = new TemplateRequestURLBuilder(VelocityEngine.newVelocityEngine(), template, TemplateRequestURLBuilder.EncodingStyle.path, (Function)new StringDigester("SHA-1", StringDigester.OutputFormat.HEX_LOWER));
            this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildSocketFactory(false));
            this.resolver = new FunctionDrivenDynamicHTTPMetadataResolver(this.httpClientBuilder.buildClient());
            this.resolver.setId("myDynamicResolver");
            this.resolver.setParserPool(parserPool);
            this.resolver.setRequestURLBuilder((Function)requestURLBuilder);
            this.resolver.initialize();
            CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)});
            EntityDescriptor ed = this.resolver.resolveSingle(criteriaSet);
            Assert.assertNotNull((Object)ed);
            Assert.assertEquals((String)ed.getEntityID(), (String)entityID);
            Assert.assertNull((Object)ed.getDOM());
        }
        finally {
            System.setProperty("javax.net.ssl.trustStore", "");
            System.setProperty("javax.net.ssl.trustStorePassword", "");
        }
    }

    @Test
    public void testHTTPSTrustEngineExplicitKey() throws Exception {
        String template = RepositorySupport.buildHTTPSResourceURL((String)"java-opensaml", (String)"opensaml-saml-impl/src/test/resources/org/opensaml/saml/metadata/resolver/impl/${entityID}.xml");
        String entityID = "https://www.example.org/sp";
        TemplateRequestURLBuilder requestURLBuilder = new TemplateRequestURLBuilder(VelocityEngine.newVelocityEngine(), template, TemplateRequestURLBuilder.EncodingStyle.path, (Function)new StringDigester("SHA-1", StringDigester.OutputFormat.HEX_LOWER));
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildSocketFactory());
        this.resolver = new FunctionDrivenDynamicHTTPMetadataResolver(this.httpClientBuilder.buildClient());
        this.resolver.setId("myDynamicResolver");
        this.resolver.setParserPool(parserPool);
        this.resolver.setRequestURLBuilder((Function)requestURLBuilder);
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildExplicitKeyTrustEngine("repo-entity.crt"));
        this.resolver.setHttpClientSecurityParameters(params);
        this.resolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)});
        EntityDescriptor ed = this.resolver.resolveSingle(criteriaSet);
        Assert.assertNotNull((Object)ed);
        Assert.assertEquals((String)ed.getEntityID(), (String)entityID);
        Assert.assertNull((Object)ed.getDOM());
    }

    @Test
    public void testHTTPSTrustEngineInvalidKey() throws Exception {
        String template = RepositorySupport.buildHTTPSResourceURL((String)"java-opensaml", (String)"opensaml-saml-impl/src/test/resources/org/opensaml/saml/metadata/resolver/impl/${entityID}.xml");
        String entityID = "https://www.example.org/sp";
        TemplateRequestURLBuilder requestURLBuilder = new TemplateRequestURLBuilder(VelocityEngine.newVelocityEngine(), template, TemplateRequestURLBuilder.EncodingStyle.path, (Function)new StringDigester("SHA-1", StringDigester.OutputFormat.HEX_LOWER));
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildSocketFactory());
        this.resolver = new FunctionDrivenDynamicHTTPMetadataResolver(this.httpClientBuilder.buildClient());
        this.resolver.setId("myDynamicResolver");
        this.resolver.setParserPool(parserPool);
        this.resolver.setRequestURLBuilder((Function)requestURLBuilder);
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildExplicitKeyTrustEngine("badKey.crt"));
        this.resolver.setHttpClientSecurityParameters(params);
        this.resolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)});
        EntityDescriptor ed = this.resolver.resolveSingle(criteriaSet);
        Assert.assertNull((Object)ed);
    }

    @Test
    public void testHTTPSTrustEngineValidPKIX() throws Exception {
        String template = RepositorySupport.buildHTTPSResourceURL((String)"java-opensaml", (String)"opensaml-saml-impl/src/test/resources/org/opensaml/saml/metadata/resolver/impl/${entityID}.xml");
        String entityID = "https://www.example.org/sp";
        TemplateRequestURLBuilder requestURLBuilder = new TemplateRequestURLBuilder(VelocityEngine.newVelocityEngine(), template, TemplateRequestURLBuilder.EncodingStyle.path, (Function)new StringDigester("SHA-1", StringDigester.OutputFormat.HEX_LOWER));
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildSocketFactory());
        this.resolver = new FunctionDrivenDynamicHTTPMetadataResolver(this.httpClientBuilder.buildClient());
        this.resolver.setId("myDynamicResolver");
        this.resolver.setParserPool(parserPool);
        this.resolver.setRequestURLBuilder((Function)requestURLBuilder);
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildPKIXTrustEngine("repo-rootCA.crt", null, false));
        this.resolver.setHttpClientSecurityParameters(params);
        this.resolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)});
        EntityDescriptor ed = this.resolver.resolveSingle(criteriaSet);
        Assert.assertNotNull((Object)ed);
        Assert.assertEquals((String)ed.getEntityID(), (String)entityID);
        Assert.assertNull((Object)ed.getDOM());
    }

    @Test
    public void testHTTPSTrustEngineValidPKIXExplicitName() throws Exception {
        String template = RepositorySupport.buildHTTPSResourceURL((String)"java-opensaml", (String)"opensaml-saml-impl/src/test/resources/org/opensaml/saml/metadata/resolver/impl/${entityID}.xml");
        String entityID = "https://www.example.org/sp";
        TemplateRequestURLBuilder requestURLBuilder = new TemplateRequestURLBuilder(VelocityEngine.newVelocityEngine(), template, TemplateRequestURLBuilder.EncodingStyle.path, (Function)new StringDigester("SHA-1", StringDigester.OutputFormat.HEX_LOWER));
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildSocketFactory());
        this.resolver = new FunctionDrivenDynamicHTTPMetadataResolver(this.httpClientBuilder.buildClient());
        this.resolver.setId("myDynamicResolver");
        this.resolver.setParserPool(parserPool);
        this.resolver.setRequestURLBuilder((Function)requestURLBuilder);
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildPKIXTrustEngine("repo-rootCA.crt", "test.shibboleth.net", true));
        this.resolver.setHttpClientSecurityParameters(params);
        this.resolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)});
        EntityDescriptor ed = this.resolver.resolveSingle(criteriaSet);
        Assert.assertNotNull((Object)ed);
        Assert.assertEquals((String)ed.getEntityID(), (String)entityID);
        Assert.assertNull((Object)ed.getDOM());
    }

    @Test
    public void testHTTPSTrustEngineInvalidPKIX() throws Exception {
        String template = RepositorySupport.buildHTTPSResourceURL((String)"java-opensaml", (String)"opensaml-saml-impl/src/test/resources/org/opensaml/saml/metadata/resolver/impl/${entityID}.xml");
        String entityID = "https://www.example.org/sp";
        TemplateRequestURLBuilder requestURLBuilder = new TemplateRequestURLBuilder(VelocityEngine.newVelocityEngine(), template, TemplateRequestURLBuilder.EncodingStyle.path, (Function)new StringDigester("SHA-1", StringDigester.OutputFormat.HEX_LOWER));
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildSocketFactory());
        this.resolver = new FunctionDrivenDynamicHTTPMetadataResolver(this.httpClientBuilder.buildClient());
        this.resolver.setId("myDynamicResolver");
        this.resolver.setParserPool(parserPool);
        this.resolver.setRequestURLBuilder((Function)requestURLBuilder);
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildPKIXTrustEngine("badCA.crt", null, false));
        this.resolver.setHttpClientSecurityParameters(params);
        this.resolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)});
        EntityDescriptor ed = this.resolver.resolveSingle(criteriaSet);
        Assert.assertNull((Object)ed);
    }

    @Test
    public void testHTTPSTrustEngineValidPKIXInvalidName() throws Exception {
        String template = RepositorySupport.buildHTTPSResourceURL((String)"java-opensaml", (String)"opensaml-saml-impl/src/test/resources/org/opensaml/saml/metadata/resolver/impl/${entityID}.xml");
        String entityID = "https://www.example.org/sp";
        TemplateRequestURLBuilder requestURLBuilder = new TemplateRequestURLBuilder(VelocityEngine.newVelocityEngine(), template, TemplateRequestURLBuilder.EncodingStyle.path, (Function)new StringDigester("SHA-1", StringDigester.OutputFormat.HEX_LOWER));
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildSocketFactory());
        this.resolver = new FunctionDrivenDynamicHTTPMetadataResolver(this.httpClientBuilder.buildClient());
        this.resolver.setId("myDynamicResolver");
        this.resolver.setParserPool(parserPool);
        this.resolver.setRequestURLBuilder((Function)requestURLBuilder);
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildPKIXTrustEngine("repo-rootCA.crt", "foobar.shibboleth.net", true));
        this.resolver.setHttpClientSecurityParameters(params);
        this.resolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)});
        EntityDescriptor ed = this.resolver.resolveSingle(criteriaSet);
        Assert.assertNull((Object)ed);
    }

    @Test
    public void testHTTPSTrustEngineWrongSocketFactory() throws Exception {
        String template = RepositorySupport.buildHTTPSResourceURL((String)"java-opensaml", (String)"opensaml-saml-impl/src/test/resources/org/opensaml/saml/metadata/resolver/impl/${entityID}.xml");
        String entityID = "https://www.example.org/sp";
        TemplateRequestURLBuilder requestURLBuilder = new TemplateRequestURLBuilder(VelocityEngine.newVelocityEngine(), template, TemplateRequestURLBuilder.EncodingStyle.path, (Function)new StringDigester("SHA-1", StringDigester.OutputFormat.HEX_LOWER));
        this.resolver = new FunctionDrivenDynamicHTTPMetadataResolver(this.httpClientBuilder.buildClient());
        this.resolver.setId("myDynamicResolver");
        this.resolver.setParserPool(parserPool);
        this.resolver.setRequestURLBuilder((Function)requestURLBuilder);
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildExplicitKeyTrustEngine("repo-entity.crt"));
        this.resolver.setHttpClientSecurityParameters(params);
        this.resolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)});
        EntityDescriptor ed = this.resolver.resolveSingle(criteriaSet);
        Assert.assertNull((Object)ed);
    }
}

